/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.mgmt;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StatusManager {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private long inWork;
    private long noChange;
    private long succeeded;
    private long failed;
    private String startTime;
    private String version;
    private static StatusManager instance;

    public static StatusManager getInstance() {
        if (instance == null) {
            instance = new StatusManager();
        }
        return instance;
    }

    private StatusManager() {
        this.reset();
    }

    protected void reset() {
        this.inWork = 0L;
        this.noChange = 0L;
        this.succeeded = 0L;
        this.failed = 0L;
        this.startTime = DATE_FORMAT.format(new Date());
    }

    public synchronized void startingWork() {
        ++this.inWork;
    }

    public synchronized void noChangeCompletion() {
        ++this.noChange;
        --this.inWork;
    }

    public synchronized void successfulCompletion() {
        ++this.succeeded;
        --this.inWork;
    }

    public synchronized void failedCompletion() {
        ++this.failed;
        --this.inWork;
    }

    public long getInWork() {
        return this.inWork;
    }

    public long getNoChange() {
        return this.noChange;
    }

    public long getSucceeded() {
        return this.succeeded;
    }

    public long getFailed() {
        return this.failed;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPrintableStatus() {
        StringBuilder status = new StringBuilder();
        status.append("\n--------------------------------------\n");
        status.append(" Retrieval Tool " + this.version + " - Status");
        status.append("\n--------------------------------------\n");
        status.append("Start Time: " + this.startTime + "\n");
        status.append("Current Time: " + DATE_FORMAT.format(new Date()) + "\n");
        status.append("Retrievals In Process: " + this.getInWork() + "\n");
        status.append("Successful Retrievals: " + this.getSucceeded() + "\n");
        status.append("No Change Needed: " + this.getNoChange() + "\n");
        status.append("Failed Retrievals: " + this.getFailed() + "\n");
        status.append("--------------------------------------\n");
        return status.toString();
    }
}

