/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.duracloud.snapshot.service.impl.ManifestEntry;
import org.duracloud.snapshot.service.impl.ManifestFileHelper;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

public class DpnManifestReader
extends StepExecutionSupport
implements ItemReader<ManifestEntry> {
    private File manifestFile;
    private BufferedReader reader;

    public DpnManifestReader(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    @Override
    public synchronized ManifestEntry read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        String line;
        if (this.reader == null) {
            this.reader = new BufferedReader(new FileReader(this.manifestFile));
            long linesRead = this.getItemsRead();
            if (linesRead > 0L) {
                for (long i = 0L; i < linesRead; ++i) {
                    this.reader.readLine();
                }
            }
        }
        if ((line = this.reader.readLine()) != null) {
            return ManifestFileHelper.parseManifestEntry(line);
        }
        return null;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
    }
}

