/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.ParallelIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions2;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.Procedures;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.block.procedure.DoubleSumResultHolder;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure2;
import org.eclipse.collections.impl.lazy.parallel.Batch;
import org.eclipse.collections.impl.lazy.parallel.RootBatch;
import org.eclipse.collections.impl.list.mutable.CompositeFastList;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMapUnsafe;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.set.mutable.SetAdapter;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelIterable<T, B extends Batch<T>>
implements ParallelIterable<T> {
    protected static <T> void forEach(final AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Procedure<? super T> procedure) {
        LazyIterable futures = parallelIterable.split().collect(new Function<RootBatch<T>, Future<?>>(){

            @Override
            public Future<?> valueOf(final RootBatch<T> chunk) {
                return parallelIterable.getExecutorService().submit(new Runnable(){

                    public void run() {
                        chunk.forEach(procedure);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static <T> boolean anySatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        final ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = parallelIterable.split().collect(new Function<RootBatch<T>, Future<Boolean>>(){

            @Override
            public Future<Boolean> valueOf(final RootBatch<T> batch) {
                return completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return batch.anySatisfy(predicate);
                    }
                });
            }
        }, UnifiedSet.newSet());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return true;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected static <T> boolean allSatisfy(AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        final ExecutorCompletionService completionService = new ExecutorCompletionService(parallelIterable.getExecutorService());
        MutableSet futures = parallelIterable.split().collect(new Function<RootBatch<T>, Future<Boolean>>(){

            @Override
            public Future<Boolean> valueOf(final RootBatch<T> batch) {
                return completionService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return batch.allSatisfy(predicate);
                    }
                });
            }
        }, UnifiedSet.newSet());
        while (futures.notEmpty()) {
            try {
                Future future = completionService.take();
                if (!((Boolean)future.get()).booleanValue()) {
                    for (Future eachFuture : futures) {
                        eachFuture.cancel(true);
                    }
                    return false;
                }
                futures.remove(future);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected static <T> T detect(final AbstractParallelIterable<T, ? extends RootBatch<T>> parallelIterable, final Predicate<? super T> predicate) {
        LazyIterable<RootBatch<T>> chunks = parallelIterable.split();
        LazyIterable futures = chunks.collect(new Function<RootBatch<T>, Future<T>>(){

            @Override
            public Future<T> valueOf(final RootBatch<T> chunk) {
                return parallelIterable.getExecutorService().submit(new Callable<T>(){

                    @Override
                    public T call() {
                        return chunk.detect(predicate);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                Object eachResult = future.get();
                if (eachResult == null) continue;
                for (Future eachFutureToCancel : futuresList) {
                    eachFutureToCancel.cancel(true);
                }
                return (T)eachResult;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public abstract ExecutorService getExecutorService();

    public abstract int getBatchSize();

    public abstract LazyIterable<B> split();

    protected abstract boolean isOrdered();

    protected <S, V> void collectCombine(Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        if (this.isOrdered()) {
            this.collectCombineOrdered(function, combineProcedure, state);
        } else {
            this.collectCombineUnordered(function, combineProcedure, state);
        }
    }

    private <S, V> void collectCombineOrdered(final Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<V>>(){

            @Override
            public Future<V> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<V>(){

                    @Override
                    public V call() {
                        return function.valueOf(chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        for (Future future : futuresList) {
            try {
                combineProcedure.value(state, future.get());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <S, V> void collectCombineUnordered(final Function<Batch<T>, V> function, Procedure2<S, V> combineProcedure, S state) {
        LazyIterable<B> chunks = this.split();
        MutableList callables = chunks.collect(new Function<Batch<T>, Callable<V>>(){

            @Override
            public Callable<V> valueOf(final Batch<T> chunk) {
                return new Callable<V>(){

                    @Override
                    public V call() {
                        return function.valueOf(chunk);
                    }
                };
            }
        }).toList();
        final ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.forEach(new Procedure<Callable<V>>(){

            @Override
            public void value(Callable<V> callable) {
                completionService.submit(callable);
            }
        });
        for (int numTasks = callables.size(); numTasks > 0; --numTasks) {
            try {
                Future future = completionService.take();
                combineProcedure.value(state, future.get());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private T collectReduce(Function<Batch<T>, T> map2, Function2<T, T, T> function2) {
        return this.isOrdered() ? this.collectReduceOrdered(map2, function2) : this.collectReduceUnordered(map2, function2);
    }

    private T collectReduceOrdered(final Function<Batch<T>, T> map2, Function2<T, T, T> function2) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<T>>(){

            @Override
            public Future<T> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<T>(){

                    @Override
                    public T call() {
                        return map2.valueOf(chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        try {
            Object result = ((Future)futuresList.getFirst()).get();
            for (int i = 1; i < futuresList.size(); ++i) {
                Object next = ((Future)futuresList.get(i)).get();
                if (next == null) continue;
                result = result == null ? next : function2.value(result, next);
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw (NullPointerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private T collectReduceUnordered(final Function<Batch<T>, T> map2, Function2<T, T, T> function2) {
        LazyIterable<B> chunks = this.split();
        MutableList callables = chunks.collect(new Function<Batch<T>, Callable<T>>(){

            @Override
            public Callable<T> valueOf(final Batch<T> chunk) {
                return new Callable<T>(){

                    @Override
                    public T call() {
                        return map2.valueOf(chunk);
                    }
                };
            }
        }).toList();
        final ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutorService());
        callables.forEach(new Procedure<Callable<T>>(){

            @Override
            public void value(Callable<T> callable) {
                completionService.submit(callable);
            }
        });
        try {
            Object result = completionService.take().get();
            for (int numTasks = callables.size() - 1; numTasks > 0; --numTasks) {
                Object next = completionService.take().get();
                if (next == null) continue;
                result = result == null ? next : function2.value(result, next);
            }
            if (result == null) {
                throw new NoSuchElementException();
            }
            return (T)result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw (NullPointerException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        try {
            appendable.append(start);
            Function map2 = new Function<Batch<T>, String>(){

                @Override
                public String valueOf(Batch<T> batch) {
                    return batch.makeString(separator);
                }
            };
            CheckedProcedure2<Appendable, String> reduce = new CheckedProcedure2<Appendable, String>(){
                private boolean first = true;

                @Override
                public void safeValue(Appendable accumulator, String each2) throws IOException {
                    if ("".equals(each2)) {
                        return;
                    }
                    if (this.first) {
                        this.first = false;
                    } else {
                        appendable.append(separator);
                    }
                    appendable.append(each2);
                }
            };
            this.collectCombine(map2, reduce, appendable);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.forEach(Procedures.bind(procedure, parameter));
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.allSatisfy(Predicates.not(predicate));
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.detect(Predicates.bind(predicate, parameter));
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        T result = this.detect(predicate);
        return result == null ? function.value() : result;
    }

    @Override
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        return this.detectIfNone(Predicates.bind(predicate, parameter), function);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    @Override
    public <E> E[] toArray(E[] array) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toArray() not implemented yet");
    }

    @Override
    public MutableList<T> toList() {
        Function map2 = new Function<Batch<T>, FastList<T>>(){

            @Override
            public FastList<T> valueOf(Batch<T> batch) {
                FastList list = FastList.newList();
                batch.forEach(CollectionAddProcedure.on(list));
                return list;
            }
        };
        Procedure2 reduce = new Procedure2<MutableList<T>, FastList<T>>(){

            @Override
            public void value(MutableList<T> accumulator, FastList<T> each2) {
                accumulator.addAll(each2);
            }
        };
        CompositeFastList state = new CompositeFastList();
        this.collectCombine(map2, reduce, state);
        return state;
    }

    @Override
    public MutableList<T> toSortedList() {
        return this.toList().toSortedList();
    }

    @Override
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        return this.toList().toSortedList(comparator);
    }

    @Override
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        return this.toSortedList(Comparators.byFunction(function));
    }

    @Override
    public MutableSet<T> toSet() {
        ConcurrentHashMapUnsafe map2 = ConcurrentHashMapUnsafe.newMap();
        Set result = Collections.newSetFromMap(map2);
        this.forEach(CollectionAddProcedure.on(result));
        return SetAdapter.adapt(map2.keySet());
    }

    @Override
    public MutableSortedSet<T> toSortedSet() {
        MutableCollection result = TreeSortedSet.newSet().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        return this.toSortedSet(Comparators.byFunction(function));
    }

    @Override
    public MutableBag<T> toBag() {
        MutableCollection result = HashBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public MutableSortedBag<T> toSortedBag() {
        MutableCollection result = TreeBag.newBag().asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        MutableCollection result = TreeBag.newBag(comparator).asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        return this.toSortedBag(Comparators.byFunction(function));
    }

    @Override
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        MutableCollection result = TreeSortedSet.newSet(comparator).asSynchronized();
        this.forEach(CollectionAddProcedure.on(result));
        return result;
    }

    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMapIterable map2 = UnifiedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(map2, keyFunction, valueFunction));
        return map2;
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMapIterable sortedMap = TreeSortedMap.newMap().asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        MutableMapIterable sortedMap = TreeSortedMap.newMap(comparator).asSynchronized();
        this.forEach(new MapCollectProcedure<T, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        ConcurrentHashMapUnsafe map2 = ConcurrentHashMapUnsafe.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }

    @Override
    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        ConcurrentHashMapUnsafe map2 = ConcurrentHashMapUnsafe.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public int count(final Predicate<? super T> predicate) {
        Function map2 = new Function<Batch<T>, Integer>(){

            @Override
            public Integer valueOf(Batch<T> batch) {
                return batch.count(predicate);
            }
        };
        Procedure2<Counter, Integer> combineProcedure = new Procedure2<Counter, Integer>(){

            @Override
            public void value(Counter counter, Integer eachCount) {
                counter.add(eachCount);
            }
        };
        Counter state = new Counter();
        this.collectCombineUnordered(map2, combineProcedure, state);
        return state.getCount();
    }

    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.count(Predicates.bind(predicate, parameter));
    }

    @Override
    public T min(final Comparator<? super T> comparator) {
        Function map2 = new Function<Batch<T>, T>(){

            @Override
            public T valueOf(Batch<T> batch) {
                return batch.min(comparator);
            }
        };
        return this.collectReduce(map2, Functions2.min(comparator));
    }

    @Override
    public T max(final Comparator<? super T> comparator) {
        Function map2 = new Function<Batch<T>, T>(){

            @Override
            public T valueOf(Batch<T> batch) {
                return batch.max(comparator);
            }
        };
        return this.collectReduce(map2, Functions2.max(comparator));
    }

    @Override
    public T min() {
        return this.min(Comparators.naturalOrder());
    }

    @Override
    public T max() {
        return this.max(Comparators.naturalOrder());
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(final Function<? super T, ? extends V> function) {
        Function map2 = new Function<Batch<T>, T>(){

            @Override
            public T valueOf(Batch<T> batch) {
                return batch.minBy(function);
            }
        };
        return this.collectReduce(map2, Functions2.minBy(function));
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(final Function<? super T, ? extends V> function) {
        Function map2 = new Function<Batch<T>, T>(){

            @Override
            public T valueOf(Batch<T> batch) {
                return batch.maxBy(function);
            }
        };
        return this.collectReduce(map2, Functions2.maxBy(function));
    }

    @Override
    public long sumOfInt(final IntFunction<? super T> function) {
        LongFunction map2 = new LongFunction<Batch<T>>(){

            @Override
            public long longValueOf(Batch<T> batch) {
                return batch.sumOfInt(function);
            }
        };
        return this.sumOfLongOrdered(map2);
    }

    @Override
    public double sumOfFloat(final FloatFunction<? super T> function) {
        Function map2 = new Function<Batch<T>, DoubleSumResultHolder>(){

            @Override
            public DoubleSumResultHolder valueOf(Batch<T> batch) {
                return batch.sumOfFloat(function);
            }
        };
        return this.sumOfDoubleOrdered(map2);
    }

    @Override
    public long sumOfLong(final LongFunction<? super T> function) {
        LongFunction map2 = new LongFunction<Batch<T>>(){

            @Override
            public long longValueOf(Batch<T> batch) {
                return batch.sumOfLong(function);
            }
        };
        return this.sumOfLongOrdered(map2);
    }

    @Override
    public double sumOfDouble(final DoubleFunction<? super T> function) {
        Function map2 = new Function<Batch<T>, DoubleSumResultHolder>(){

            @Override
            public DoubleSumResultHolder valueOf(Batch<T> batch) {
                return batch.sumOfDouble(function);
            }
        };
        return this.sumOfDoubleOrdered(map2);
    }

    private long sumOfLongOrdered(final LongFunction<Batch<T>> map2) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<Long>>(){

            @Override
            public Future<Long> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<Long>(){

                    @Override
                    public Long call() {
                        return map2.longValueOf(chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        try {
            long result = 0L;
            for (int i = 0; i < futuresList.size(); ++i) {
                result += ((Long)((Future)futuresList.get(i)).get()).longValue();
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private double sumOfDoubleOrdered(final Function<Batch<T>, DoubleSumResultHolder> map2) {
        LazyIterable<B> chunks = this.split();
        LazyIterable futures = chunks.collect(new Function<Batch<T>, Future<DoubleSumResultHolder>>(){

            @Override
            public Future<DoubleSumResultHolder> valueOf(final Batch<T> chunk) {
                return AbstractParallelIterable.this.getExecutorService().submit(new Callable<DoubleSumResultHolder>(){

                    @Override
                    public DoubleSumResultHolder call() {
                        return (DoubleSumResultHolder)map2.valueOf(chunk);
                    }
                });
            }
        });
        MutableList futuresList = futures.toList();
        try {
            double sum2 = 0.0;
            double compensation = 0.0;
            for (int i = 0; i < futuresList.size(); ++i) {
                double adjustedValue = ((DoubleSumResultHolder)((Future)futuresList.get(i)).get()).getResult() - (compensation += ((DoubleSumResultHolder)((Future)futuresList.get(i)).get()).getCompensation());
                double nextSum = sum2 + adjustedValue;
                compensation = nextSum - sum2 - adjustedValue;
                sum2 = nextSum;
            }
            return sum2;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(final Function<? super T, ? extends V> function) {
        final ConcurrentHashMap result = ConcurrentHashMap.newMap();
        this.forEach(new Procedure<T>(){

            @Override
            public void value(T value) {
                Object key = function.valueOf(value);
                if (result.put(key, value) != null) {
                    throw new IllegalStateException("Key " + key + " already exists in map!");
                }
            }
        });
        return result;
    }
}

