/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

public class ReverseShortIterable
extends AbstractLazyShortIterable {
    private final ShortList adapted;

    public ReverseShortIterable(ShortList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseShortIterable adapt(ShortList shortList) {
        return new ReverseShortIterable(shortList);
    }

    public ShortIterator shortIterator() {
        return new ReverseShortIterator();
    }

    public void each(ShortProcedure procedure) {
        ShortIterator iterator2 = this.shortIterator();
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public short max() {
        return this.adapted.max();
    }

    public short min() {
        return this.adapted.min();
    }

    public short minIfEmpty(short defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public short[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public short[] toArray() {
        short[] results = new short[this.adapted.size()];
        int index = 0;
        ShortIterator iterator2 = this.shortIterator();
        while (iterator2.hasNext()) {
            results[index] = iterator2.next();
            ++index;
        }
        return results;
    }

    public boolean contains(short value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableShortList toList() {
        return ShortArrayList.newList(this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet(this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag(this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    private class ReverseShortIterator
    implements ShortIterator {
        private int currentIndex;

        private ReverseShortIterator() {
            this.currentIndex = ReverseShortIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short next = ReverseShortIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

