/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.CharToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharDoublePredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.map.primitive.CharDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableCharDoubleMap;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharDoublePair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.CharDoubleMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableCharKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableCharMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableCharKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedCharDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableCharDoubleMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharDoubleHashMap
extends AbstractMutableDoubleValuesMap
implements MutableCharDoubleMap,
Externalizable,
MutableCharKeysMap {
    private static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableDoubleValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public CharDoubleHashMap() {
        this.allocateTable(16);
    }

    public CharDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public CharDoubleHashMap(CharDoubleMap map2) {
        if (map2 instanceof CharDoubleHashMap && ((CharDoubleHashMap)map2).occupiedWithSentinels == 0) {
            CharDoubleHashMap hashMap = (CharDoubleHashMap)map2;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map2.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map2);
        }
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1) {
        return new CharDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1, char key2, double value2) {
        return new CharDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1, char key2, double value2, char key3, double value3) {
        return new CharDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharDoubleHashMap newWithKeysValues(char key1, double value1, char key2, double value2, char key3, double value3, char key4, double value4) {
        return new CharDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected double getEmptyValue() {
        return 0.0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected double getValueAtIndex(int index) {
        return this.values[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharDoubleMap)) {
            return false;
        }
        CharDoubleMap other = (CharDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow('\u0000')) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || Double.compare(this.sentinelValues.oneValue, other.getOrThrow('\u0001')) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append('\u0000').append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append('\u0001').append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharDoubleHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public MutableDoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, 0.0);
    }

    @Override
    public void put(char key, double value) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(double value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    @Override
    public void putAll(CharDoubleMap map2) {
        map2.forEachKeyValue(new CharDoubleProcedure(){

            public void value(char key, double value) {
                CharDoubleHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(char key) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    @Override
    public void remove(char key) {
        this.removeKey(key);
    }

    @Override
    public double removeKeyIfAbsent(char key, double value) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            double oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    @Override
    public double getIfAbsentPut(char key, double value) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getIfAbsentPut(char key, DoubleFunction0 function) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.value();
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> double getIfAbsentPutWith(char key, DoubleFunction<? super P> function, P parameter) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.doubleValueOf(parameter);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.doubleValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.doubleValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double getIfAbsentPutWithKey(char key, CharToDoubleFunction function) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        double value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public double addToValue(char key, double toBeAdded) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(char key, double value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = '\u0001';
        this.values[index] = 0.0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        char[] copy = new char[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    @Override
    public double updateValue(char key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableDoubleValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        double value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public CharDoubleHashMap withKeyValue(char key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public CharDoubleHashMap withKeysValues(char key1, double value1, char key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharDoubleHashMap withKeysValues(char key1, double value1, char key2, double value2, char key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharDoubleHashMap withKeysValues(char key1, double value1, char key2, double value2, char key3, double value3, char key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public CharDoubleHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public CharDoubleHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharDoubleHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    @Override
    public MutableCharDoubleMap asUnmodifiable() {
        return new UnmodifiableCharDoubleMap(this);
    }

    @Override
    public MutableCharDoubleMap asSynchronized() {
        return new SynchronizedCharDoubleMap(this);
    }

    @Override
    public ImmutableCharDoubleMap toImmutable() {
        return CharDoubleMaps.immutable.ofAll(this);
    }

    @Override
    public double get(char key) {
        return this.getIfAbsent(key, 0.0);
    }

    @Override
    public double getIfAbsent(char key, double ifAbsent) {
        if (CharDoubleHashMap.isEmptyKey(key) || CharDoubleHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private double getForSentinel(char key, double ifAbsent) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private double slowGetIfAbsent(char key, double ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private double fastGetIfAbsent(char key, double ifAbsent) {
        int index = this.mask(key);
        for (int i = 0; i < 16; ++i) {
            char keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == '\u0000') {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private double slowGetIfAbsentTwo(char key, double ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public double getOrThrow(char key) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(char key) {
        if (CharDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    @Override
    public void forEachKeyValue(CharDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    @Override
    public LazyCharIterable keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<CharDoublePair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public CharDoubleHashMap select(CharDoublePredicate predicate) {
        CharDoubleHashMap result = new CharDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public CharDoubleHashMap reject(CharDoublePredicate predicate) {
        CharDoubleHashMap result = new CharDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        for (int i = 0; i < size2; ++i) {
            this.put(in.readChar(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(char element) {
        int index = this.mask(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(char element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            char keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(char element, int removedIndex) {
        int nextIndex = SpreadFunctions.charSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.charSpreadTwo(element)) | 1;
        char keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == '\u0000') {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != '\u0001' || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(char element) {
        int code = SpreadFunctions.charSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(char element) {
        int code = SpreadFunctions.charSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharDoubleHashMap.isEmptyKey(key) && !CharDoubleHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !CharDoubleHashMap.isEmptyKey(this.keys[index]) && !CharDoubleHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    @Override
    public MutableCharSet keySet() {
        return new KeySet();
    }

    @Override
    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$302(CharDoubleHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(CharDoubleHashMap x0, double[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<CharDoublePair> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super CharDoublePair> procedure) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.zeroValue));
                }
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharDoubleHashMap.this.keys[i], CharDoubleHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super CharDoublePair> objectIntProcedure) {
            int index = 0;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0000', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair('\u0001', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(CharDoubleHashMap.this.keys[i], CharDoubleHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super CharDoublePair, ? super P> procedure, P parameter) {
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair('\u0000', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair('\u0001', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(CharDoubleHashMap.this.keys[i], CharDoubleHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<CharDoublePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<CharDoublePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharDoublePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharDoubleHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharDoubleHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.oneValue);
                    }
                }
                char[] keys = CharDoubleHashMap.this.keys;
                while (!CharDoubleHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharDoublePair result = PrimitiveTuples.pair(keys[this.position], CharDoubleHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharDoubleHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableDoubleValuesMap.AbstractDoubleValuesCollection {
        private ValuesCollection() {
        }

        public MutableDoubleIterator doubleIterator() {
            return CharDoubleHashMap.this.doubleIterator();
        }

        public boolean remove(double item) {
            int oldSize = CharDoubleHashMap.this.size();
            if (CharDoubleHashMap.this.sentinelValues != null) {
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsZeroKey && Double.compare(item, ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.zeroValue) == 0) {
                    CharDoubleHashMap.this.removeKey('\u0000');
                }
                if (((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsOneKey && Double.compare(item, ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.oneValue) == 0) {
                    CharDoubleHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharDoubleHashMap.this.keys.length; ++i) {
                if (!CharDoubleHashMap.isNonSentinel(CharDoubleHashMap.this.keys[i]) || Double.compare(item, CharDoubleHashMap.this.values[i]) != 0) continue;
                CharDoubleHashMap.this.removeKey(CharDoubleHashMap.this.keys[i]);
            }
            return oldSize != CharDoubleHashMap.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = CharDoubleHashMap.this.size();
            final DoubleSet sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            CharDoubleHashMap retained = CharDoubleHashMap.this.select(new CharDoublePredicate(){

                public boolean accept(char key, double value) {
                    return sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                CharDoubleHashMap.access$302(CharDoubleHashMap.this, retained.keys);
                CharDoubleHashMap.access$502(CharDoubleHashMap.this, retained.values);
                CharDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                CharDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableCharKeySet {
        private KeySet() {
        }

        protected MutableCharKeysMap getOuter() {
            return CharDoubleHashMap.this;
        }

        protected AbstractMutableDoubleValuesMap.SentinelValues getSentinelValues() {
            return CharDoubleHashMap.this.sentinelValues;
        }

        protected char getKeyAtIndex(int index) {
            return CharDoubleHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return CharDoubleHashMap.this.keys.length;
        }

        public MutableCharIterator charIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = CharDoubleHashMap.this.size();
            final CharSet sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharDoubleHashMap retained = CharDoubleHashMap.this.select(new CharDoublePredicate(){

                public boolean accept(char key, double value) {
                    return sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                CharDoubleHashMap.access$302(CharDoubleHashMap.this, retained.keys);
                CharDoubleHashMap.access$502(CharDoubleHashMap.this, retained.values);
                CharDoubleHashMap.this.sentinelValues = retained.sentinelValues;
                CharDoubleHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharDoubleHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public CharSet freeze() {
            CharDoubleHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (CharDoubleHashMap.this.sentinelValues != null) {
                containsZeroKey = ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((CharDoubleHashMap)CharDoubleHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableCharMapKeySet(CharDoubleHashMap.this.keys, CharDoubleHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableCharIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharDoubleHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharDoubleHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharDoubleHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return this.lastKey;
                }
            }
            char[] keys = CharDoubleHashMap.this.keys;
            while (!CharDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        public CharIterator charIterator() {
            return new UnmodifiableCharIterator(new KeySetIterator());
        }

        public void each(CharProcedure procedure) {
            CharDoubleHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalDoubleIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private char lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < CharDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharDoubleHashMap.this.containsKey('\u0000')) {
                    this.lastKey = '\u0000';
                    return CharDoubleHashMap.this.get('\u0000');
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharDoubleHashMap.this.containsKey('\u0001')) {
                    this.lastKey = '\u0001';
                    return CharDoubleHashMap.this.get('\u0001');
                }
            }
            char[] keys = CharDoubleHashMap.this.keys;
            while (!CharDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            double result = CharDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            CharDoubleHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

