/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionContract;
import org.hibernate.Transaction;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.spi.ConnectionObserver;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.ConnectionObserverStatsBridge;
import org.hibernate.internal.QueryImpl;
import org.hibernate.internal.SQLQueryImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.WrapperOptionsImpl;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureCallMemento;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.resource.jdbc.spi.JdbcObserver;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.WrapperOptions;

public abstract class AbstractSessionImpl
implements Serializable,
SharedSessionContract,
SessionImplementor,
JdbcSessionOwner,
TransactionCoordinatorBuilder.TransactionCoordinatorOptions {
    protected transient SessionFactoryImpl factory;
    private final String tenantIdentifier;
    private boolean closed;
    protected transient Transaction currentHibernateTransaction;
    protected transient WrapperOptionsImpl wrapperOptions;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private UUID sessionIdentifier;

    protected AbstractSessionImpl(SessionFactoryImpl factory, String tenantIdentifier) {
        this.factory = factory;
        this.tenantIdentifier = tenantIdentifier;
        if (MultiTenancyStrategy.NONE == factory.getSettings().getMultiTenancyStrategy()) {
            if (tenantIdentifier != null) {
                throw new HibernateException("SessionFactory was not configured for multi-tenancy");
            }
        } else if (tenantIdentifier == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public abstract boolean shouldAutoJoinTransaction();

    @Override
    public <T> T execute(final LobCreationContext.Callback<T> callback) {
        return this.getJdbcCoordinator().coordinateWork(new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                try {
                    return callback.executeOnConnection(connection);
                }
                catch (SQLException e) {
                    throw AbstractSessionImpl.this.getFactory().getSQLExceptionHelper().convert(e, "Error creating contextual LOB : " + e.getMessage());
                }
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.factory.isClosed();
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.isClosed()) {
            throw new SessionException("Session is closed!");
        }
    }

    @Override
    public Query createQuery(NamedQueryDefinition namedQueryDefinition) {
        String queryString = namedQueryDefinition.getQueryString();
        QueryImpl query = new QueryImpl(queryString, namedQueryDefinition.getFlushMode(), this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query.setComment(namedQueryDefinition.getComment() != null ? namedQueryDefinition.getComment() : namedQueryDefinition.getName());
        if (namedQueryDefinition.getLockOptions() != null) {
            query.setLockOptions(namedQueryDefinition.getLockOptions());
        }
        return query;
    }

    @Override
    public SQLQuery createSQLQuery(NamedSQLQueryDefinition namedQueryDefinition) {
        ParameterMetadata parameterMetadata = this.factory.getQueryPlanCache().getSQLParameterMetadata(namedQueryDefinition.getQueryString());
        SQLQueryImpl query = new SQLQueryImpl(namedQueryDefinition, (SessionImplementor)this, parameterMetadata);
        query.setComment(namedQueryDefinition.getComment() != null ? namedQueryDefinition.getComment() : namedQueryDefinition.getName());
        return query;
    }

    @Override
    public Query getNamedQuery(String queryName) throws MappingException {
        Query query;
        this.errorIfClosed();
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            query = this.createQuery(nqd);
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            query = this.createSQLQuery(nsqlqd);
            nqd = nsqlqd;
        }
        this.initQuery(query, nqd);
        return query;
    }

    @Override
    public Query getNamedSQLQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named SQL query not known: " + queryName);
        }
        SQLQueryImpl query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
        query.setComment(nsqlqd.getComment() != null ? nsqlqd.getComment() : nsqlqd.getName());
        this.initQuery(query, nsqlqd);
        return query;
    }

    private void initQuery(Query query, NamedQueryDefinition nqd) {
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        query.setReadOnly(nqd.isReadOnly());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query.setCacheMode(nqd.getCacheMode());
        }
        if (nqd.getComment() != null) {
            query.setComment(nqd.getComment());
        }
        if (nqd.getFirstResult() != null) {
            query.setFirstResult(nqd.getFirstResult());
        }
        if (nqd.getMaxResults() != null) {
            query.setMaxResults(nqd.getMaxResults());
        }
        if (nqd.getFlushMode() != null) {
            query.setFlushMode(nqd.getFlushMode());
        }
    }

    @Override
    public Query createQuery(String queryString) {
        this.errorIfClosed();
        QueryImpl query = new QueryImpl(queryString, this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query.setComment(queryString);
        return query;
    }

    @Override
    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        SQLQueryImpl query = new SQLQueryImpl(sql, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
        query.setComment("dynamic native SQL query");
        return query;
    }

    @Override
    public ProcedureCall getNamedProcedureCall(String name) {
        this.errorIfClosed();
        ProcedureCallMemento memento = this.factory.getNamedQueryRepository().getNamedProcedureCallMemento(name);
        if (memento == null) {
            throw new IllegalArgumentException("Could not find named stored procedure call with that registration name : " + name);
        }
        ProcedureCall procedureCall = memento.makeProcedureCall(this);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.errorIfClosed();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SessionImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        this.errorIfClosed();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SessionImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.errorIfClosed();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SessionImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    protected HQLQueryPlan getHQLQueryPlan(String query, boolean shallow) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(query, shallow, this.getLoadQueryInfluencers().getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification spec) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(spec);
    }

    @Override
    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        if (this.currentHibernateTransaction == null || this.currentHibernateTransaction.getStatus() != TransactionStatus.ACTIVE) {
            this.currentHibernateTransaction = new TransactionImpl(this.getTransactionCoordinator());
        }
        this.getTransactionCoordinator().pulse();
        return this.currentHibernateTransaction;
    }

    @Override
    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    @Override
    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return new EntityKey(id, persister);
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = MultiTenancyStrategy.NONE == this.factory.getSettings().getMultiTenancyStrategy() ? new NonContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(ConnectionProvider.class)) : new ContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(MultiTenantConnectionProvider.class));
        }
        return this.jdbcConnectionAccess;
    }

    public UUID getSessionIdentifier() {
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(this);
        }
        return this.sessionIdentifier;
    }

    @Override
    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
        return this.factory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
    }

    @Override
    public WrapperOptions getWrapperOptions() {
        if (this.wrapperOptions == null) {
            this.wrapperOptions = new WrapperOptionsImpl(this);
        }
        return this.wrapperOptions;
    }

    public class JdbcObserverImpl
    implements JdbcObserver {
        private final transient List<ConnectionObserver> observers = new ArrayList<ConnectionObserver>();

        public JdbcObserverImpl() {
            this.observers.add(new ConnectionObserverStatsBridge(AbstractSessionImpl.this.factory));
        }

        @Override
        public void jdbcConnectionAcquisitionStart() {
        }

        @Override
        public void jdbcConnectionAcquisitionEnd(Connection connection) {
            for (ConnectionObserver observer : this.observers) {
                observer.physicalConnectionObtained(connection);
            }
        }

        @Override
        public void jdbcConnectionReleaseStart() {
        }

        @Override
        public void jdbcConnectionReleaseEnd() {
            for (ConnectionObserver observer : this.observers) {
                observer.physicalConnectionReleased();
            }
        }

        @Override
        public void jdbcPrepareStatementStart() {
            AbstractSessionImpl.this.getEventListenerManager().jdbcPrepareStatementStart();
        }

        @Override
        public void jdbcPrepareStatementEnd() {
            for (ConnectionObserver observer : this.observers) {
                observer.statementPrepared();
            }
            AbstractSessionImpl.this.getEventListenerManager().jdbcPrepareStatementEnd();
        }

        @Override
        public void jdbcExecuteStatementStart() {
            AbstractSessionImpl.this.getEventListenerManager().jdbcExecuteStatementStart();
        }

        @Override
        public void jdbcExecuteStatementEnd() {
            AbstractSessionImpl.this.getEventListenerManager().jdbcExecuteStatementEnd();
        }

        @Override
        public void jdbcExecuteBatchStart() {
            AbstractSessionImpl.this.getEventListenerManager().jdbcExecuteBatchStart();
        }

        @Override
        public void jdbcExecuteBatchEnd() {
            AbstractSessionImpl.this.getEventListenerManager().jdbcExecuteBatchEnd();
        }
    }

    public class JdbcSessionContextImpl
    implements JdbcSessionContext {
        private final SessionFactoryImpl sessionFactory;
        private final StatementInspector inspector;
        private final PhysicalConnectionHandlingMode connectionHandlingMode;
        private final transient ServiceRegistry serviceRegistry;
        private final transient JdbcObserver jdbcObserver;

        public JdbcSessionContextImpl(SessionFactoryImpl sessionFactory, StatementInspector inspector) {
            this.sessionFactory = sessionFactory;
            this.inspector = inspector;
            this.connectionHandlingMode = this.settings().getPhysicalConnectionHandlingMode();
            this.serviceRegistry = sessionFactory.getServiceRegistry();
            this.jdbcObserver = new JdbcObserverImpl();
            if (inspector == null) {
                throw new IllegalArgumentException("StatementInspector cannot be null");
            }
        }

        @Override
        public boolean isScrollableResultSetsEnabled() {
            return this.settings().isScrollableResultSetsEnabled();
        }

        @Override
        public boolean isGetGeneratedKeysEnabled() {
            return this.settings().isGetGeneratedKeysEnabled();
        }

        @Override
        public int getFetchSize() {
            return this.settings().getJdbcFetchSize();
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public ConnectionReleaseMode getConnectionReleaseMode() {
            return this.connectionHandlingMode.getReleaseMode();
        }

        @Override
        public ConnectionAcquisitionMode getConnectionAcquisitionMode() {
            return this.connectionHandlingMode.getAcquisitionMode();
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.inspector;
        }

        @Override
        public JdbcObserver getObserver() {
            return this.jdbcObserver;
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            return this.sessionFactory;
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        private SessionFactoryOptions settings() {
            return this.sessionFactory.getSessionFactoryOptions();
        }
    }

    private class ContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final SessionEventListener listener;
        private final MultiTenantConnectionProvider connectionProvider;

        private ContextualJdbcConnectionAccess(SessionEventListener listener2, MultiTenantConnectionProvider connectionProvider) {
            this.listener = listener2;
            this.connectionProvider = connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            try {
                this.listener.jdbcConnectionAcquisitionStart();
                Connection connection = this.connectionProvider.getConnection(AbstractSessionImpl.this.tenantIdentifier);
                return connection;
            }
            finally {
                this.listener.jdbcConnectionAcquisitionEnd();
            }
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            try {
                this.listener.jdbcConnectionReleaseStart();
                this.connectionProvider.releaseConnection(AbstractSessionImpl.this.tenantIdentifier, connection);
            }
            finally {
                this.listener.jdbcConnectionReleaseEnd();
            }
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    private static class NonContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final SessionEventListener listener;
        private final ConnectionProvider connectionProvider;

        private NonContextualJdbcConnectionAccess(SessionEventListener listener2, ConnectionProvider connectionProvider) {
            this.listener = listener2;
            this.connectionProvider = connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            try {
                this.listener.jdbcConnectionAcquisitionStart();
                Connection connection = this.connectionProvider.getConnection();
                return connection;
            }
            finally {
                this.listener.jdbcConnectionAcquisitionEnd();
            }
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            try {
                this.listener.jdbcConnectionReleaseStart();
                this.connectionProvider.closeConnection(connection);
            }
            finally {
                this.listener.jdbcConnectionReleaseEnd();
            }
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

