/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CollectionHelper {
    public static final int MINIMUM_INITIAL_CAPACITY = 16;
    public static final float LOAD_FACTOR = 0.75f;
    @Deprecated
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;
    @Deprecated
    public static final Collection EMPTY_COLLECTION = Collections.EMPTY_LIST;
    @Deprecated
    public static final Map EMPTY_MAP = Collections.EMPTY_MAP;

    private CollectionHelper() {
    }

    public static <K, V> Map<K, V> mapOfSize(int size2) {
        return new HashMap(CollectionHelper.determineProperSizing(size2), 0.75f);
    }

    public static int determineProperSizing(Map original) {
        return CollectionHelper.determineProperSizing(original.size());
    }

    public static int determineProperSizing(Set original) {
        return CollectionHelper.determineProperSizing(original.size());
    }

    public static int determineProperSizing(int numberOfElements) {
        int actual = (int)((float)numberOfElements / 0.75f) + 1;
        return Math.max(actual, 16);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int expectedNumberOfElements) {
        return CollectionHelper.concurrentMap(expectedNumberOfElements, 0.75f);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int expectedNumberOfElements, float loadFactor) {
        int size2 = expectedNumberOfElements + 1 + (int)((float)expectedNumberOfElements * loadFactor);
        return new ConcurrentHashMap(size2, loadFactor);
    }

    public static <T> ArrayList<T> arrayList(int anticipatedSize) {
        return new ArrayList(anticipatedSize);
    }

    public static <T> Set<T> makeCopy(Set<T> source) {
        if (source == null) {
            return null;
        }
        int size2 = source.size();
        HashSet<T> copy = new HashSet<T>(size2 + 1);
        copy.addAll(source);
        return copy;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map2) {
        return map2 == null || map2.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionHelper.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map map2) {
        return !CollectionHelper.isEmpty(map2);
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static <X, Y> Map<X, Y> makeCopy(Map<X, Y> map2) {
        Map<X, Y> copy = CollectionHelper.mapOfSize(map2.size() + 1);
        copy.putAll(map2);
        return copy;
    }
}

