/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Utils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0017\u0010!\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001f\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aJ\b\u0010(\u001a\u00020$H\u0016J\u0018\u0010)\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\fH\u0016J\u0011\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000-H\u0096\u0002J\u0017\u0010.\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010*J\"\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u0010%\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u00100R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lorg/mapdb/IndexTreeList;", "E", "Ljava/util/AbstractList;", "store", "Lorg/mapdb/Store;", "serializer", "Lorg/mapdb/Serializer;", "map", "Lorg/eclipse/collections/api/map/primitive/MutableLongLongMap;", "counterRecid", "", "isThreadSafe", "", "(Lorg/mapdb/Store;Lorg/mapdb/Serializer;Lorg/eclipse/collections/api/map/primitive/MutableLongLongMap;JZ)V", "getCounterRecid", "()J", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getMap", "()Lorg/eclipse/collections/api/map/primitive/MutableLongLongMap;", "getSerializer", "()Lorg/mapdb/Serializer;", "size", "", "getSize", "()I", "setSize", "(I)V", "getStore", "()Lorg/mapdb/Store;", "add", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "checkIndex", "clear", "get", "(I)Ljava/lang/Object;", "isEmpty", "iterator", "", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "mapdb"})
public final class IndexTreeList<E>
extends AbstractList<E> {
    @Nullable
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Store store;
    @NotNull
    private final Serializer<E> serializer;
    @NotNull
    private final MutableLongLongMap map;
    private final long counterRecid;
    private final boolean isThreadSafe;

    @Nullable
    public final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@Nullable E element) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            IndexTreeList indexTreeList = this;
            int n = indexTreeList.size();
            indexTreeList.setSize(n + 1);
            int index = n;
            long recid2 = this.store.put(element, this.serializer);
            this.map.put(index, recid2);
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void add(int index, @Nullable E element) {
        void lock$iv;
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.checkIndex(index);
            int n = this.size() - 1;
            int n2 = index;
            if (n >= n2) {
                while (true) {
                    void i;
                    long recid2;
                    if ((recid2 = this.map.get((long)i)) != 0L) {
                        this.map.remove((long)i);
                        this.map.put((long)(i + true), recid2);
                    }
                    if (i == n2) break;
                    --i;
                }
            }
            IndexTreeList indexTreeList = this;
            n = indexTreeList.size();
            indexTreeList.setSize(n + 1);
            long recid3 = this.map.get(index);
            if (recid3 == 0L) {
                this.map.put(index, this.store.put(element, this.serializer));
            } else {
                this.store.update(recid3, element, this.serializer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.setSize(0);
            this.map.forEachValue(new LongProcedure(this){
                final /* synthetic */ IndexTreeList this$0;

                public final void value(long recid2) {
                    this.this$0.getStore().delete(recid2, this.this$0.getSerializer());
                }
                {
                    this.this$0 = indexTreeList;
                }
            });
            this.map.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public E removeAt(int index) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            E e;
            this.checkIndex(index);
            long recid2 = this.map.get(index);
            if (recid2 == 0L) {
                e = null;
            } else {
                E ret2 = this.store.get(recid2, this.serializer);
                this.store.delete(recid2, this.serializer);
                this.map.remove(index);
                e = ret2;
            }
            E ret3 = e;
            IntRange intRange = RangesKt.until(index + 1, this.size());
            int ret2 = intRange.getFirst();
            int n = intRange.getLast();
            if (ret2 <= n) {
                while (true) {
                    void i;
                    long recid3;
                    if ((recid3 = this.map.get((long)i)) != 0L) {
                        this.map.remove((long)i);
                        this.map.put((long)(i - true), recid3);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            IndexTreeList indexTreeList = this;
            int n2 = indexTreeList.size();
            indexTreeList.setSize(n2 + -1);
            E e2 = ret3;
            return e2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public E set(int index, @Nullable E element) {
        void lock$iv;
        Utils utils = Utils.INSTANCE;
        ReadWriteLock readWriteLock = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.checkIndex(index);
            long recid2 = this.map.get(index);
            if (recid2 == 0L) {
                this.map.put(index, this.store.put(element, this.serializer));
                E e = null;
                return e;
            }
            E ret2 = this.store.get(recid2, this.serializer);
            this.store.update(recid2, element, this.serializer);
            E e = ret2;
            return e;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public final void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public E get(int index) {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            this.checkIndex(index);
            long recid2 = this.map.get(index);
            if (recid2 == 0L) {
                E e = null;
                return e;
            }
            E e = this.store.get(recid2, this.serializer);
            return e;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(this){
            private volatile int index;
            @Nullable
            private volatile Integer indexToRemove;
            final /* synthetic */ IndexTreeList this$0;

            public final int getIndex() {
                return this.index;
            }

            public final void setIndex(int n) {
                this.index = n;
            }

            @Nullable
            public final Integer getIndexToRemove() {
                return this.indexToRemove;
            }

            public final void setIndexToRemove(@Nullable Integer n) {
                this.indexToRemove = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Utils utils = Utils.INSTANCE;
                ReadWriteLock lock$iv = this.this$0.getLock();
                if (lock$iv != null) {
                    lock$iv.readLock().lock();
                }
                try {
                    boolean bl = this.index < this.this$0.size();
                    return bl;
                }
                finally {
                    if (lock$iv != null) {
                        lock$iv.readLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public E next() {
                Utils utils = Utils.INSTANCE;
                ReadWriteLock lock$iv = this.this$0.getLock();
                if (lock$iv != null) {
                    lock$iv.readLock().lock();
                }
                try {
                    void var3_3;
                    if (this.index >= this.this$0.size()) {
                        throw (Throwable)new NoSuchElementException();
                    }
                    this.indexToRemove = this.index;
                    E ret2 = this.this$0.get(this.index);
                    int n = this.index;
                    this.index = n + 1;
                    void var8_5 = var3_3;
                    return var8_5;
                }
                finally {
                    if (lock$iv != null) {
                        lock$iv.readLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                Utils utils = Utils.INSTANCE;
                ReadWriteLock lock$iv = this.this$0.getLock();
                if (lock$iv != null) {
                    lock$iv.writeLock().lock();
                }
                try {
                    Integer n = this.indexToRemove;
                    if (n == null) {
                        throw (Throwable)new IllegalStateException();
                    }
                    this.this$0.remove(n);
                    int n2 = this.index;
                    this.index = n2 + -1;
                    this.indexToRemove = null;
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    if (lock$iv != null) {
                        lock$iv.writeLock().unlock();
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public int getSize() {
        Serializer serializer = Serializer.LONG_PACKED;
        Intrinsics.checkExpressionValueIsNotNull(serializer, "Serializer.LONG_PACKED");
        Object r = this.store.get(this.counterRecid, serializer);
        if (r == null) {
            Intrinsics.throwNpe();
        }
        return (int)((Number)r).longValue();
    }

    protected void setSize(int size2) {
        Long l = size2;
        Serializer serializer = Serializer.LONG_PACKED;
        Intrinsics.checkExpressionValueIsNotNull(serializer, "Serializer.LONG_PACKED");
        this.store.update(this.counterRecid, l, serializer);
    }

    @NotNull
    public final Store getStore() {
        return this.store;
    }

    @NotNull
    public final Serializer<E> getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final MutableLongLongMap getMap() {
        return this.map;
    }

    public final long getCounterRecid() {
        return this.counterRecid;
    }

    public final boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public IndexTreeList(@NotNull Store store, @NotNull Serializer<E> serializer, @NotNull MutableLongLongMap map2, long counterRecid, boolean isThreadSafe) {
        Intrinsics.checkParameterIsNotNull(store, "store");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Intrinsics.checkParameterIsNotNull(map2, "map");
        this.store = store;
        this.serializer = serializer;
        this.map = map2;
        this.counterRecid = counterRecid;
        this.isThreadSafe = isThreadSafe;
        this.lock = this.isThreadSafe ? new ReentrantReadWriteLock() : (ReentrantReadWriteLock)null;
    }
}

