/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;

public class SerializerArrayTuple
implements GroupSerializer<Object[]> {
    protected final Serializer[] ser;
    protected final Comparator[] comp;
    protected final int size;

    public SerializerArrayTuple(Serializer[] serializers, Comparator[] comparators) {
        this.ser = (Serializer[])serializers.clone();
        this.comp = (Comparator[])comparators.clone();
        this.size = this.ser.length;
    }

    public SerializerArrayTuple(Serializer ... serializers) {
        this.ser = (Serializer[])serializers.clone();
        this.comp = this.ser;
        this.size = this.ser.length;
    }

    protected Object[] cast(Object o) {
        if (((Object[])o).length % this.size != 0) {
            throw new AssertionError();
        }
        return (Object[])o;
    }

    @Override
    public void serialize(@NotNull DataOutput2 out, @NotNull Object[] value) throws IOException {
        for (int i = 0; i < this.size; ++i) {
            this.ser[i].serialize(out, value[i]);
        }
    }

    @Override
    public Object[] deserialize(@NotNull DataInput2 input, int available) throws IOException {
        Object[] v = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            v[i] = this.ser[i].deserialize(input, -1);
        }
        return v;
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        Object[] v = this.cast(vals);
        for (int i = 0; i < v.length; ++i) {
            this.ser[i % this.size].serialize(out, v[i]);
        }
    }

    @Override
    public Object valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        Object[] v = new Object[size2 * this.size];
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.ser[i % this.size].deserialize(in, -1);
        }
        return v;
    }

    @Override
    public int valueArraySearch(Object keys, Object[] key) {
        return Arrays.binarySearch(this.valueArrayToArray(keys), key, this);
    }

    @Override
    public int valueArraySearch(Object keys, Object[] key, Comparator comparator) {
        return Arrays.binarySearch(this.valueArrayToArray(keys), key, comparator);
    }

    @Override
    public Object[] valueArrayGet(Object vals, int pos) {
        return Arrays.copyOfRange(this.cast(vals), pos *= this.size, pos + this.size);
    }

    @Override
    public int valueArraySize(Object vals) {
        return this.cast(vals).length / this.size;
    }

    @Override
    public Object valueArrayEmpty() {
        return new Object[0];
    }

    @Override
    public Object valueArrayPut(Object vals, int pos, Object[] newValue) {
        if (newValue.length % this.size != 0) {
            throw new AssertionError();
        }
        Object[] array = this.cast(vals);
        Object[] ret2 = Arrays.copyOf(array, array.length + this.size);
        if ((pos *= this.size) < array.length) {
            System.arraycopy(array, pos, ret2, pos + this.size, array.length - pos);
        }
        System.arraycopy(newValue, 0, ret2, pos, this.size);
        return ret2;
    }

    @Override
    public Object valueArrayUpdateVal(Object vals, int pos, Object[] newValue) {
        if (newValue.length != this.size) {
            throw new AssertionError();
        }
        Object[] ret2 = (Object[])this.cast(vals).clone();
        System.arraycopy(newValue, 0, ret2, pos * this.size, this.size);
        return ret2;
    }

    @Override
    public Object valueArrayFromArray(Object[] objects) {
        Object[] v = new Object[objects.length * this.size];
        int pos = 0;
        for (Object oo : objects) {
            Object[] oo2 = (Object[])oo;
            if (oo2.length != this.size) {
                throw new AssertionError();
            }
            for (Object o : oo2) {
                v[pos++] = o;
            }
        }
        return v;
    }

    @Override
    public Object valueArrayCopyOfRange(Object vals, int from, int to) {
        return Arrays.copyOfRange(this.cast(vals), from * this.size, to * this.size);
    }

    @Override
    public Object valueArrayDeleteValue(Object vals0, int pos) {
        Object[] vals = this.cast(vals0);
        Object[] vals2 = new Object[vals.length - this.size];
        System.arraycopy(vals, 0, vals2, 0, (pos *= this.size) - this.size);
        System.arraycopy(vals, pos, vals2, pos - this.size, vals2.length - (pos - this.size));
        return vals2;
    }

    @Override
    public Object[] nextValue(Object[] value) {
        return Arrays.copyOf(value, value.length + 1);
    }

    @Override
    public boolean equals(Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (this.ser[i % this.size].equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            Object a1 = o1[i];
            Object a2 = o2[i];
            if (a1 == a2) continue;
            if (a1 == null) {
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            int res = this.comp[i].compare(a1, a2);
            if (res == 0) continue;
            return res;
        }
        return Integer.compare(o1.length, o2.length);
    }

    @Override
    public int hashCode(@NotNull Object[] objects, int seed) {
        if (objects.length % this.size != 0) {
            throw new AssertionError();
        }
        for (int i = 0; i < objects.length; ++i) {
            seed += DataIO.intHash(this.ser[i].hashCode(objects[i], seed));
        }
        return seed;
    }

    @Override
    public boolean isTrusted() {
        for (Serializer s : this.ser) {
            if (s.isTrusted()) continue;
            return false;
        }
        return true;
    }
}

