/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.GenericApplicationContextFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class ClasspathXmlApplicationContextsFactoryBean
implements FactoryBean<ApplicationContextFactory[]>,
ApplicationContextAware {
    private List<Resource> resources = new ArrayList<Resource>();
    private boolean copyConfiguration = true;
    private Class<? extends BeanFactoryPostProcessor>[] beanFactoryPostProcessorClasses;
    private Class<?>[] beanPostProcessorExcludeClasses;
    private ApplicationContext applicationContext;

    public void setResources(Resource[] resources) {
        this.resources = Arrays.asList(resources);
    }

    public void setCopyConfiguration(boolean copyConfiguration) {
        this.copyConfiguration = copyConfiguration;
    }

    public void setBeanFactoryPostProcessorClasses(Class<? extends BeanFactoryPostProcessor>[] beanFactoryPostProcessorClasses) {
        this.beanFactoryPostProcessorClasses = beanFactoryPostProcessorClasses;
    }

    public void setBeanPostProcessorExcludeClasses(Class<?>[] beanPostProcessorExcludeClasses) {
        this.beanPostProcessorExcludeClasses = beanPostProcessorExcludeClasses;
    }

    @Override
    public ApplicationContextFactory[] getObject() throws Exception {
        if (this.resources == null) {
            return new ApplicationContextFactory[0];
        }
        ArrayList<GenericApplicationContextFactory> applicationContextFactories = new ArrayList<GenericApplicationContextFactory>();
        for (Resource resource : this.resources) {
            GenericApplicationContextFactory factory = new GenericApplicationContextFactory(resource);
            factory.setCopyConfiguration(this.copyConfiguration);
            if (this.beanFactoryPostProcessorClasses != null) {
                factory.setBeanFactoryPostProcessorClasses(this.beanFactoryPostProcessorClasses);
            }
            if (this.beanPostProcessorExcludeClasses != null) {
                factory.setBeanPostProcessorExcludeClasses(this.beanPostProcessorExcludeClasses);
            }
            factory.setApplicationContext(this.applicationContext);
            applicationContextFactories.add(factory);
        }
        return applicationContextFactories.toArray(new ApplicationContextFactory[applicationContextFactories.size()]);
    }

    @Override
    public Class<?> getObjectType() {
        return ApplicationContextFactory[].class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

