/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class JsrJobParametersConverter
implements JobParametersConverter,
InitializingBean {
    public static final String JOB_RUN_ID = "jsr_batch_run_id";
    public DataFieldMaxValueIncrementer incremeter;
    public String tablePrefix = "BATCH_";
    public DataSource dataSource;

    public JsrJobParametersConverter(DataSource dataSource) {
        Assert.notNull(dataSource, "A DataSource is required");
        this.dataSource = dataSource;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        DefaultDataFieldMaxValueIncrementerFactory factory = new DefaultDataFieldMaxValueIncrementerFactory(this.dataSource);
        this.incremeter = factory.getIncrementer(DatabaseType.fromMetaData(this.dataSource).name(), this.tablePrefix + "JOB_SEQ");
    }

    @Override
    public JobParameters getJobParameters(Properties properties) {
        JobParametersBuilder builder = new JobParametersBuilder();
        boolean runIdFound = false;
        if (properties != null) {
            for (Map.Entry<Object, Object> curParameter : properties.entrySet()) {
                if (curParameter.getValue() == null) continue;
                if (curParameter.getKey().equals(JOB_RUN_ID)) {
                    runIdFound = true;
                    builder.addLong(curParameter.getKey().toString(), Long.valueOf((String)curParameter.getValue()), true);
                    continue;
                }
                builder.addString(curParameter.getKey().toString(), curParameter.getValue().toString(), false);
            }
        }
        if (!runIdFound) {
            builder.addLong(JOB_RUN_ID, this.incremeter.nextLongValue());
        }
        return builder.toJobParameters();
    }

    @Override
    public Properties getProperties(JobParameters params) {
        Properties properties = new Properties();
        boolean runIdFound = false;
        if (params != null) {
            for (Map.Entry<String, JobParameter> curParameter : params.getParameters().entrySet()) {
                if (curParameter.getKey().equals(JOB_RUN_ID)) {
                    runIdFound = true;
                }
                properties.setProperty(curParameter.getKey(), curParameter.getValue().getValue().toString());
            }
        }
        if (!runIdFound) {
            properties.setProperty(JOB_RUN_ID, String.valueOf(this.incremeter.nextLongValue()));
        }
        return properties;
    }
}

