/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractSqlPagingQueryProvider
implements PagingQueryProvider {
    private String selectClause;
    private String fromClause;
    private String whereClause;
    private Map<String, Order> sortKeys = new LinkedHashMap<String, Order>();
    private String groupClause;
    private int parameterCount;
    private boolean usingNamedParameters;

    public void setGroupClause(String groupClause) {
        this.groupClause = StringUtils.hasText(groupClause) ? this.removeKeyWord("group by", groupClause) : null;
    }

    public String getGroupClause() {
        return this.groupClause;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = this.removeKeyWord("select", selectClause);
    }

    protected String getSelectClause() {
        return this.selectClause;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = this.removeKeyWord("from", fromClause);
    }

    protected String getFromClause() {
        return this.fromClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = StringUtils.hasText(whereClause) ? this.removeKeyWord("where", whereClause) : null;
    }

    protected String getWhereClause() {
        return this.whereClause;
    }

    public void setSortKeys(Map<String, Order> sortKeys) {
        this.sortKeys = sortKeys;
    }

    @Override
    public Map<String, Order> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public boolean isUsingNamedParameters() {
        return this.usingNamedParameters;
    }

    @Override
    public String getSortKeyPlaceHolder(String keyName) {
        return this.usingNamedParameters ? ":_" + keyName : "?";
    }

    @Override
    public void init(DataSource dataSource) throws Exception {
        Assert.notNull(dataSource);
        Assert.hasLength(this.selectClause, "selectClause must be specified");
        Assert.hasLength(this.fromClause, "fromClause must be specified");
        Assert.notEmpty(this.sortKeys, "sortKey must be specified");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.selectClause);
        sql.append(" FROM ").append(this.fromClause);
        if (this.whereClause != null) {
            sql.append(" WHERE ").append(this.whereClause);
        }
        if (this.groupClause != null) {
            sql.append(" GROUP BY ").append(this.groupClause);
        }
        ArrayList<String> namedParameters = new ArrayList<String>();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders(sql.toString(), namedParameters);
        if (namedParameters.size() > 0) {
            if (this.parameterCount != namedParameters.size()) {
                throw new InvalidDataAccessApiUsageException("You can't use both named parameters and classic \"?\" placeholders: " + sql);
            }
            this.usingNamedParameters = true;
        }
    }

    @Override
    public abstract String generateFirstPageQuery(int var1);

    @Override
    public abstract String generateRemainingPagesQuery(int var1);

    @Override
    public abstract String generateJumpToItemQuery(int var1, int var2);

    private String removeKeyWord(String keyWord, String clause) {
        String temp = clause.trim();
        String keyWordString = keyWord + " ";
        if (temp.toLowerCase().startsWith(keyWordString) && temp.length() > keyWordString.length()) {
            return temp.substring(keyWordString.length());
        }
        return temp;
    }

    @Override
    public Map<String, Order> getSortKeysWithoutAliases() {
        LinkedHashMap<String, Order> sortKeysWithoutAliases = new LinkedHashMap<String, Order>();
        for (Map.Entry<String, Order> sortKeyEntry : this.sortKeys.entrySet()) {
            String key = sortKeyEntry.getKey();
            int separator = key.indexOf(46);
            if (separator > 0) {
                int columnIndex = separator + 1;
                if (columnIndex >= key.length()) continue;
                sortKeysWithoutAliases.put(key.substring(columnIndex), sortKeyEntry.getValue());
                continue;
            }
            sortKeysWithoutAliases.put(sortKeyEntry.getKey(), sortKeyEntry.getValue());
        }
        return sortKeysWithoutAliases;
    }
}

