/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.util.StringUtils;

public class SqlPagingQueryUtils {
    public static String generateLimitSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String limitClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        sql.append(" " + limitClause);
        return sql.toString();
    }

    public static String generateLimitGroupedSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String limitClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * ");
        sql.append(" FROM (");
        sql.append("SELECT ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(") AS MAIN_QRY ");
        sql.append("WHERE ");
        SqlPagingQueryUtils.buildSortConditions(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        sql.append(" " + limitClause);
        return sql.toString();
    }

    public static String generateTopSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String topClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(topClause).append(" ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        return sql.toString();
    }

    public static String generateGroupedTopSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String topClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(topClause).append(" * FROM (");
        sql.append("SELECT ").append(provider.getSelectClause());
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(") AS MAIN_QRY ");
        sql.append("WHERE ");
        SqlPagingQueryUtils.buildSortConditions(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        return sql.toString();
    }

    public static String generateRowNumSqlQuery(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, String rowNumClause) {
        return SqlPagingQueryUtils.generateRowNumSqlQuery(provider, provider.getSelectClause(), remainingPageQuery, rowNumClause);
    }

    public static String generateRowNumSqlQuery(AbstractSqlPagingQueryProvider provider, String selectClause, boolean remainingPageQuery, String rowNumClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM (SELECT ").append(selectClause);
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        sql.append(") WHERE ").append(rowNumClause);
        if (remainingPageQuery) {
            sql.append(" AND ");
            SqlPagingQueryUtils.buildSortConditions(provider, sql);
        }
        return sql.toString();
    }

    public static String generateRowNumSqlQueryWithNesting(AbstractSqlPagingQueryProvider provider, String selectClause, boolean remainingPageQuery, String rowNumClause) {
        return SqlPagingQueryUtils.generateRowNumSqlQueryWithNesting(provider, selectClause, selectClause, remainingPageQuery, rowNumClause);
    }

    public static String generateRowNumSqlQueryWithNesting(AbstractSqlPagingQueryProvider provider, String innerSelectClause, String outerSelectClause, boolean remainingPageQuery, String rowNumClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(outerSelectClause).append(" FROM (SELECT ").append(outerSelectClause).append(", ").append(StringUtils.hasText(provider.getGroupClause()) ? "MIN(ROWNUM) as TMP_ROW_NUM" : "ROWNUM as TMP_ROW_NUM");
        sql.append(" FROM (SELECT ").append(innerSelectClause).append(" FROM ").append(provider.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(provider, remainingPageQuery, sql);
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        sql.append(")) WHERE ").append(rowNumClause);
        return sql.toString();
    }

    public static String generateLimitJumpToQuery(AbstractSqlPagingQueryProvider provider, String limitClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(SqlPagingQueryUtils.buildSortKeySelect(provider));
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        sql.append(" " + limitClause);
        return sql.toString();
    }

    public static String generateTopJumpToQuery(AbstractSqlPagingQueryProvider provider, String topClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(topClause).append(" ").append(SqlPagingQueryUtils.buildSortKeySelect(provider));
        sql.append(" FROM ").append(provider.getFromClause());
        sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        SqlPagingQueryUtils.buildGroupByClause(provider, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(provider));
        return sql.toString();
    }

    public static String buildSortClause(AbstractSqlPagingQueryProvider provider) {
        return SqlPagingQueryUtils.buildSortClause(provider.getSortKeys());
    }

    public static String buildSortClause(Map<String, Order> sortKeys) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Map.Entry<String, Order> sortKey : sortKeys.entrySet()) {
            builder.append(prefix);
            prefix = ", ";
            builder.append(sortKey.getKey());
            if (sortKey.getValue() != null && sortKey.getValue() == Order.DESCENDING) {
                builder.append(" DESC");
                continue;
            }
            builder.append(" ASC");
        }
        return builder.toString();
    }

    public static void buildSortConditions(AbstractSqlPagingQueryProvider provider, StringBuilder sql) {
        ArrayList<Map.Entry<String, Order>> keys = new ArrayList<Map.Entry<String, Order>>(provider.getSortKeys().entrySet());
        ArrayList<String> clauses = new ArrayList<String>();
        for (int i = 0; i < keys.size(); ++i) {
            StringBuilder clause = new StringBuilder();
            String prefix = "";
            for (int j = 0; j < i; ++j) {
                clause.append(prefix);
                prefix = " AND ";
                Map.Entry entry = (Map.Entry)keys.get(j);
                clause.append((String)entry.getKey());
                clause.append(" = ");
                clause.append(provider.getSortKeyPlaceHolder((String)entry.getKey()));
            }
            if (clause.length() > 0) {
                clause.append(" AND ");
            }
            clause.append((String)((Map.Entry)keys.get(i)).getKey());
            if (((Map.Entry)keys.get(i)).getValue() != null && ((Map.Entry)keys.get(i)).getValue() == Order.DESCENDING) {
                clause.append(" < ");
            } else {
                clause.append(" > ");
            }
            clause.append(provider.getSortKeyPlaceHolder((String)((Map.Entry)keys.get(i)).getKey()));
            clauses.add(clause.toString());
        }
        sql.append("(");
        String prefix = "";
        for (String curClause : clauses) {
            sql.append(prefix);
            prefix = " OR ";
            sql.append("(");
            sql.append(curClause);
            sql.append(")");
        }
        sql.append(")");
    }

    private static String buildSortKeySelect(AbstractSqlPagingQueryProvider provider) {
        StringBuilder select2 = new StringBuilder();
        String prefix = "";
        for (Map.Entry<String, Order> sortKey : provider.getSortKeys().entrySet()) {
            select2.append(prefix);
            prefix = ", ";
            select2.append(sortKey.getKey());
        }
        return select2.toString();
    }

    private static void buildWhereClause(AbstractSqlPagingQueryProvider provider, boolean remainingPageQuery, StringBuilder sql) {
        if (remainingPageQuery) {
            sql.append(" WHERE ");
            if (provider.getWhereClause() != null) {
                sql.append("(");
                sql.append(provider.getWhereClause());
                sql.append(") AND ");
            }
            SqlPagingQueryUtils.buildSortConditions(provider, sql);
        } else {
            sql.append(provider.getWhereClause() == null ? "" : " WHERE " + provider.getWhereClause());
        }
    }

    private static void buildGroupByClause(AbstractSqlPagingQueryProvider provider, StringBuilder sql) {
        if (StringUtils.hasText(provider.getGroupClause())) {
            sql.append(" GROUP BY ");
            sql.append(provider.getGroupClause());
        }
    }
}

