/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.collection;

import gnu.trove.set.hash.THashSet;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;

public class WriteOnlyStringSet {
    private THashSet<String> set;
    private static final MessageDigest MD5 = DigestUtils.getMd5Digest();

    public WriteOnlyStringSet(int capacity) {
        this.set = new THashSet(capacity);
    }

    public void add(String string) {
        if (string == null) {
            return;
        }
        this.set.add(this.getMd5String(string));
    }

    private String getMd5String(String string) {
        return WriteOnlyStringSet.checksumBytesToString(MD5.digest(string.getBytes()));
    }

    public static String checksumBytesToString(byte[] digestBytes) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digestBytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & digestBytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        return this.set.contains(this.getMd5String(string));
    }

    public int size() {
        return this.set.size();
    }

    public boolean remove(String string) {
        return this.set.remove(this.getMd5String(string));
    }
}

