/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.db.repo;

import java.util.Date;
import java.util.List;
import org.duracloud.mill.db.model.ManifestItem;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="manifestItemRepo")
public interface JpaManifestItemRepo
extends JpaRepository<ManifestItem, Long> {
    public Page<ManifestItem> findByAccountAndStoreIdAndSpaceIdAndDeletedFalseOrderByContentIdAsc(String var1, String var2, String var3, Pageable var4);

    @Query(nativeQuery=true, value="select * from manifest_item where account = ?1 and store_id=?2 and space_id = ?3 and deleted = false and id > ?4 order by id limit ?5")
    public List<ManifestItem> findByAccountAndStoreIdAndSpaceIdAndDeletedFalse(String var1, String var2, String var3, long var4, int var6);

    @Query(nativeQuery=true, value="select ifnull(min(id),0) from manifest_item where account = ?1 and store_id=?2 and space_id = ?3 and deleted = false")
    public long getMinId(String var1, String var2, String var3);

    public ManifestItem findByAccountAndStoreIdAndSpaceIdAndContentId(String var1, String var2, String var3, String var4);

    @Modifying
    @Query(nativeQuery=true, value="delete from manifest_item where deleted = true and modified < ?1 limit 50000")
    public int deleteFirst50000ByDeletedTrueAndModifiedBefore(Date var1);

    public void deleteByAccountAndStoreIdAndSpaceId(String var1, String var2, String var3);

    @Query(nativeQuery=true, value="select count(*) objectCount, sum(content_size) as byteCount from manifest_item where account = :account and store_id = :storeId and space_id= :spaceId and deleted=false")
    public Object[] getStorageStatsByAccountAndStoreIdAndSpaceId(@Param(value="account") String var1, @Param(value="storeId") String var2, @Param(value="spaceId") String var3);
}

