/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.impl.ManifestEntry;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;

public class ManifestVerifier
extends StepExecutionSupport
implements ItemWriter<ManifestEntry>,
ItemWriteListener<ManifestEntry> {
    private Logger log = LoggerFactory.getLogger(ManifestVerifier.class);
    private String restorationId;
    private File contentDir;
    private RestoreManager restoreManager;

    public ManifestVerifier(String restorationId, File contentDir, RestoreManager restorationManager) {
        this.restorationId = restorationId;
        this.contentDir = contentDir;
        this.restoreManager = restorationManager;
    }

    @Override
    public void beforeWrite(List<? extends ManifestEntry> items) {
    }

    @Override
    public void afterWrite(List<? extends ManifestEntry> items) {
        this.addToItemsRead(items.size());
    }

    @Override
    public void onWriteError(Exception exception, List<? extends ManifestEntry> items) {
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    RestoreStatus newStatus = RestoreStatus.VERIFYING_RETRIEVED_CONTENT;
                    ManifestVerifier.this.restoreManager.transitionRestoreStatus(ManifestVerifier.this.restorationId, newStatus, "");
                    return null;
                }
            });
        }
        catch (Exception ex) {
            this.addError("failed to transition status to " + (Object)((Object)RestoreStatus.VERIFYING_RETRIEVED_CONTENT) + ": " + ex.getMessage());
            stepExecution.addFailureException(ex);
            this.failExecution();
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = stepExecution.getExitStatus();
        List<String> errors = this.getErrors();
        if (errors.size() > 0) {
            status = status.and(ExitStatus.FAILED);
            for (String error : errors) {
                status = status.addExitDescription(error);
            }
            this.resetContextState();
            stepExecution.upgradeStatus(BatchStatus.FAILED);
            stepExecution.setTerminateOnly();
            this.log.error("manifest verification finished: step_execution_id={} job_execution_id={} restore_id={} exit_status=\"{}\"", stepExecution.getId(), stepExecution.getJobExecutionId(), this.restorationId, status);
        } else {
            this.log.info("manifest verification finished:step_execution_id={} job_execution_id={} restore_id={} exit_status=\"{}\"", stepExecution.getId(), stepExecution.getJobExecutionId(), this.restorationId, status);
            status = status.and(ExitStatus.COMPLETED);
        }
        return status;
    }

    @Override
    public void write(List<? extends ManifestEntry> items) throws Exception {
        for (ManifestEntry manifestEntry : items) {
            try {
                String contentId = manifestEntry.getContentId();
                String checksum = manifestEntry.getChecksum();
                File file = new File(this.contentDir, contentId);
                if (!file.exists()) {
                    String message = MessageFormat.format("content ({0}) not found in path ({1}) for restore ({2})", contentId, file.getAbsolutePath(), this.restorationId);
                    this.log.error(message);
                    this.addError(message);
                    continue;
                }
                ChecksumUtil checksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
                String fileChecksum = checksumUtil.generateChecksum(file);
                if (!checksum.equals(fileChecksum)) {
                    String message = MessageFormat.format("content id ({0}) manifest checksum ({1})  does not match file ({2}) checksum ({3})", contentId, checksum, file.getAbsolutePath(), fileChecksum);
                    this.log.error(message);
                    this.addError(message);
                    continue;
                }
                this.log.debug("successfully verified entry {}", (Object)manifestEntry);
            }
            catch (Exception ex) {
                String message = "failed to verify " + manifestEntry + ": " + ex.getMessage();
                this.log.error(message, ex);
                this.addError(message);
            }
        }
    }
}

