/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.common.model.ContentItem;
import org.duracloud.manifeststitch.StitchedManifestGenerator;
import org.duracloud.retrieval.mgmt.LoggingOutputWriter;
import org.duracloud.retrieval.source.DuraStoreStitchingRetrievalSource;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.service.SnapshotJobManagerConfig;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.AbstractJobBuilder;
import org.duracloud.snapshot.service.impl.BatchJobBuilder;
import org.duracloud.snapshot.service.impl.SnapshotJobExecutionListener;
import org.duracloud.snapshot.service.impl.SnapshotJobParameterMarshaller;
import org.duracloud.snapshot.service.impl.SpaceItemReader;
import org.duracloud.snapshot.service.impl.SpaceItemWriter;
import org.duracloud.snapshot.service.impl.SpaceManifestSnapshotManifestVerifier;
import org.duracloud.snapshot.service.impl.StoreClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.factory.SimpleStepFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
public class SnapshotJobBuilder
extends AbstractJobBuilder
implements BatchJobBuilder<Snapshot> {
    private static Logger log = LoggerFactory.getLogger(SnapshotJobBuilder.class);
    private static final String MANIFEST_SHA256_TXT_FILE_NAME = "manifest-sha256.txt";
    private static final String MANIFEST_MD5_TXT_FILE_NAME = "manifest-md5.txt";
    private SnapshotJobExecutionListener jobListener;
    private JobRepository jobRepository;
    private PlatformTransactionManager transactionManager;
    private TaskExecutor taskExecutor;
    private SnapshotManager snapshotManager;
    private StoreClientHelper storeClientHelper;

    @Autowired
    public SnapshotJobBuilder(SnapshotJobExecutionListener jobListener, JobRepository jobRepository, PlatformTransactionManager transactionManager, @Qualifier(value="itemTaskExecutor") TaskExecutor taskExecutor, SnapshotManager snapshotManager, StoreClientHelper storeClientHelper) {
        this.jobListener = jobListener;
        this.jobRepository = jobRepository;
        this.transactionManager = transactionManager;
        this.taskExecutor = taskExecutor;
        this.snapshotManager = snapshotManager;
        this.storeClientHelper = storeClientHelper;
    }

    @Override
    public Job buildJob(Snapshot snapshot, SnapshotJobManagerConfig config) throws SnapshotException {
        Job job;
        try {
            DuracloudEndPointConfig source = snapshot.getSource();
            ContentStore contentStore = this.storeClientHelper.create(source, config.getDuracloudUsername(), config.getDuracloudPassword());
            ArrayList<String> spaces = new ArrayList<String>();
            spaces.add(source.getSpaceId());
            DuraStoreStitchingRetrievalSource retrievalSource = new DuraStoreStitchingRetrievalSource(contentStore, spaces, false);
            SpaceItemReader itemReader = new SpaceItemReader(retrievalSource);
            File contentDir = new File(ContentDirUtils.getDestinationPath(snapshot.getName(), config.getContentRootDir()));
            if (!contentDir.exists()) {
                contentDir.mkdirs();
            }
            File propsFile = new File(contentDir, "content-properties.json");
            File md5File = new File(contentDir, MANIFEST_MD5_TXT_FILE_NAME);
            File sha256File = new File(contentDir, MANIFEST_SHA256_TXT_FILE_NAME);
            SpaceManifestSnapshotManifestVerifier verifier = new SpaceManifestSnapshotManifestVerifier(md5File, new StitchedManifestGenerator(contentStore), source.getSpaceId());
            SpaceItemWriter itemWriter = new SpaceItemWriter(snapshot, retrievalSource, contentDir, new LoggingOutputWriter(), propsFile, md5File, sha256File, this.snapshotManager, verifier);
            SimpleStepFactoryBean<ContentItem, ContentItem> stepFactory = new SimpleStepFactoryBean<ContentItem, ContentItem>();
            stepFactory.setJobRepository(this.jobRepository);
            stepFactory.setTransactionManager(this.transactionManager);
            stepFactory.setBeanName("step1");
            stepFactory.setItemReader(itemReader);
            stepFactory.setItemWriter(itemWriter);
            stepFactory.setCommitInterval(1);
            this.setThrottleLimitForContentTransfers(stepFactory);
            stepFactory.setTaskExecutor(this.taskExecutor);
            Step step = stepFactory.getObject();
            JobBuilderFactory jobBuilderFactory = new JobBuilderFactory(this.jobRepository);
            JobBuilder jobBuilder = jobBuilderFactory.get(this.getJobName());
            SimpleJobBuilder simpleJobBuilder = jobBuilder.start(step);
            simpleJobBuilder.listener(this.jobListener);
            job = simpleJobBuilder.build();
            log.debug("build job {}", (Object)job);
        }
        catch (Exception e) {
            log.error("Error creating job: {}", (Object)e.getMessage(), (Object)e);
            throw new SnapshotException(e.getMessage(), e);
        }
        return job;
    }

    @Override
    public JobParameters buildIdentifyingJobParameters(Snapshot snapshot) {
        Map<String, JobParameter> map2 = this.createIdentifyingJobParameters(snapshot);
        JobParameters params = new JobParameters(map2);
        return params;
    }

    @Override
    public JobParameters buildJobParameters(Snapshot snapshot) {
        return this.buildIdentifyingJobParameters(snapshot);
    }

    private Map<String, JobParameter> createIdentifyingJobParameters(Snapshot snapshot) {
        return SnapshotJobParameterMarshaller.marshal(snapshot);
    }

    @Override
    public String getJobName() {
        return "snapshot";
    }
}

