/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import org.duracloud.common.collection.StreamingIterator;
import org.duracloud.common.collection.jpa.JpaIteratorSource;
import org.duracloud.snapshot.db.model.SnapshotContentItem;
import org.duracloud.snapshot.db.repo.SnapshotContentItemRepo;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class SnapshotRepoManifestReader
extends StepExecutionSupport
implements ItemReader<SnapshotContentItem> {
    private SnapshotContentItemRepo repo;
    private StreamingIterator<SnapshotContentItem> items;
    private String snapshotName;

    public SnapshotRepoManifestReader(SnapshotContentItemRepo repo, String snapshotName) {
        this.repo = repo;
        this.snapshotName = snapshotName;
    }

    @Override
    public synchronized SnapshotContentItem read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        if (this.items == null) {
            this.items = new StreamingIterator<SnapshotContentItem>(new JpaIteratorSource<SnapshotContentItemRepo, SnapshotContentItem>(this.repo){

                @Override
                protected Page<SnapshotContentItem> getNextPage(Pageable pageable, SnapshotContentItemRepo repo) {
                    return repo.findBySnapshotName(SnapshotRepoManifestReader.this.snapshotName, pageable);
                }
            });
            this.skipLinesAlreadyRead(this.items);
        }
        return this.items.hasNext() ? this.items.next() : null;
    }
}

