/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.util.DateUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.common.util.SerializationUtil;
import org.duracloud.storage.error.ChecksumMismatchException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProviderUtil {
    private static Logger log = LoggerFactory.getLogger(StorageProviderUtil.class);

    private StorageProviderUtil() {
    }

    public static Map<String, String> loadProperties(InputStream is) throws StorageException {
        Map<Object, Object> propertiesMap = null;
        if (is != null) {
            try {
                String properties = IOUtil.readStringFromStream(is);
                propertiesMap = SerializationUtil.deserializeMap(properties);
            }
            catch (Exception e) {
                String err = "Could not read properties  due to error: " + e.getMessage();
                throw new StorageException(err, e);
            }
        }
        if (propertiesMap == null) {
            propertiesMap = new HashMap();
        }
        return propertiesMap;
    }

    public static ByteArrayInputStream storeProperties(Map<String, String> propertiesMap) throws StorageException {
        propertiesMap.remove("space-count");
        byte[] properties = null;
        try {
            String serializedProperties = SerializationUtil.serializeMap(propertiesMap);
            properties = serializedProperties.getBytes("UTF-8");
        }
        catch (Exception e) {
            String err = "Could not store properties due to error: " + e.getMessage();
            throw new StorageException(err);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(properties);
        return is;
    }

    public static String compareChecksum(StorageProvider provider, String spaceId, String contentId, String checksum) throws StorageException {
        String providerChecksum = provider.getContentProperties(spaceId, contentId).get("content-checksum");
        return StorageProviderUtil.compareChecksum(providerChecksum, spaceId, contentId, checksum);
    }

    public static String compareChecksum(String providerChecksum, String spaceId, String contentId, String checksum) throws ChecksumMismatchException {
        if (!providerChecksum.equals(checksum)) {
            String err = "Content " + contentId + " was added to space " + spaceId + " but the checksum, either provided or computed enroute, (" + checksum + ") does not match the checksum computed by the storage provider (" + providerChecksum + "). This content should be retransmitted.";
            log.warn(err);
            throw new ChecksumMismatchException(err, false);
        }
        return providerChecksum;
    }

    public static boolean contains(Iterator<String> iterator2, String value) {
        if (iterator2 == null || value == null) {
            return false;
        }
        while (iterator2.hasNext()) {
            if (!value.equals(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static long count(Iterator<String> iterator2) {
        if (iterator2 == null) {
            return 0L;
        }
        long count2 = 0L;
        while (iterator2.hasNext()) {
            ++count2;
            iterator2.next();
        }
        return count2;
    }

    public static List<String> getList(Iterator<String> iterator2) {
        ArrayList<String> contents = new ArrayList<String>();
        while (iterator2.hasNext()) {
            contents.add(iterator2.next());
        }
        return contents;
    }

    public static Map<String, String> createContentProperties(String absolutePath, String creator) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (creator != null && creator.trim().length() > 0) {
            props.put("creator", creator);
        }
        props.put("content-file-path", absolutePath);
        try {
            Path path = FileSystems.getDefault().getPath(absolutePath, new String[0]);
            BasicFileAttributes bfa = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            String creationDate = DateUtil.convertToStringLong(bfa.creationTime().toMillis());
            props.put("content-file-created", creationDate);
            String lastAccessed = DateUtil.convertToStringLong(bfa.lastAccessTime().toMillis());
            props.put("content-file-last-accessed", lastAccessed);
            String modified = DateUtil.convertToStringLong(bfa.lastModifiedTime().toMillis());
            props.put("content-file-modified", modified);
        }
        catch (IOException ex) {
            log.error("Failed to read basic file attributes from " + absolutePath + ": " + ex.getMessage(), ex);
        }
        return props;
    }

    public static Map<String, String> removeCalculatedProperties(Map<String, String> contentProperties) {
        if (contentProperties != null) {
            contentProperties = new HashMap<String, String>(contentProperties);
            contentProperties.remove("content-md5");
            contentProperties.remove("content-checksum");
            contentProperties.remove("content-modified");
            contentProperties.remove("content-size");
        }
        return contentProperties;
    }
}

