/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.mgmt.ChangeHandler;
import org.duracloud.sync.mgmt.ChangeWatcher;
import org.duracloud.sync.mgmt.ChangedFile;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.SyncWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncManager
implements ChangeHandler {
    private final Logger logger = LoggerFactory.getLogger(SyncManager.class);
    private ChangeWatcher changeWatcher;
    private List<File> watchDirs;
    private SyncEndpoint endpoint;
    private ExecutorService watcherPool;
    private ThreadPoolExecutor workerPool;
    private ArrayList<SyncWorker> workerList;

    public SyncManager(List<File> watchDirs, SyncEndpoint endpoint, int threads, long frequency) {
        this.logger.info("Starting Sync Manager with " + threads + " threads");
        this.watchDirs = watchDirs;
        this.endpoint = endpoint;
        this.changeWatcher = new ChangeWatcher(ChangedList.getInstance(), this, frequency);
        this.watcherPool = Executors.newFixedThreadPool(1);
        this.workerPool = new ThreadPoolExecutor(threads, threads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.AbortPolicy());
        this.workerList = new ArrayList();
    }

    public void beginSync() {
        this.watcherPool.execute(this.changeWatcher);
    }

    public void endSync() {
        this.logger.info("Closing Sync Manager, ending sync");
        this.changeWatcher.endWatch();
        this.watcherPool.shutdown();
        this.workerPool.shutdown();
    }

    public void terminateSync() {
        this.logger.info("Closing Sync Manager, terminating sync");
        this.changeWatcher.endWatch();
        this.watcherPool.shutdownNow();
        this.workerPool.shutdownNow();
    }

    @Override
    public synchronized boolean handleChangedFile(ChangedFile changedFile) {
        File watchDir = this.getWatchDir(changedFile.getFile());
        SyncWorker worker = new SyncWorker(changedFile, watchDir, this.endpoint);
        try {
            this.addToWorkerList(worker);
            this.workerPool.execute(worker);
            return true;
        }
        catch (RejectedExecutionException e) {
            this.workerList.remove(worker);
            return false;
        }
    }

    protected File getWatchDir(File changedFile) {
        for (File watchDir : this.watchDirs) {
            for (File changedFileParent = changedFile.getParentFile(); changedFileParent != null; changedFileParent = changedFileParent.getParentFile()) {
                if (!changedFileParent.equals(watchDir)) continue;
                return watchDir;
            }
        }
        return null;
    }

    private void addToWorkerList(SyncWorker workerToAdd) {
        this.cleanWorkerList();
        for (int i = 0; i < this.workerList.size(); ++i) {
            SyncWorker worker = this.workerList.get(i);
            if (!worker.getMonitoredFile().getAbsolutePath().equals(workerToAdd.getMonitoredFile().getAbsolutePath())) continue;
            this.workerList.remove(i);
        }
        this.workerList.add(workerToAdd);
    }

    private void cleanWorkerList() {
        for (int i = 0; i < this.workerList.size(); ++i) {
            SyncWorker worker = this.workerList.get(i);
            if (!worker.isComplete()) continue;
            this.workerList.remove(i);
        }
    }

    public synchronized List<MonitoredFile> getFilesInTransfer() {
        this.cleanWorkerList();
        ArrayList<MonitoredFile> monitoredFiles = new ArrayList<MonitoredFile>();
        ArrayList<SyncWorker> workers = new ArrayList<SyncWorker>(this.workerList);
        for (SyncWorker worker : workers) {
            monitoredFiles.add(worker.getMonitoredFile());
        }
        return monitoredFiles;
    }
}

