/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongIteratorIterate {
    private LongIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(LongIterator iterator2, LongProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableLongCollection> R select(LongIterator iterator2, LongPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            long item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableLongCollection> R reject(LongIterator iterator2, LongPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            long item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(LongIterator iterator2, LongToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            long item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static long detectIfNone(LongIterator iterator2, LongPredicate predicate, long ifNone) {
        while (iterator2.hasNext()) {
            long item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(LongIterator iterator2, LongPredicate predicate) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count2;
        }
        return count2;
    }

    public static boolean anySatisfy(LongIterator iterator2, LongPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(LongIterator iterator2, LongPredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(LongIterator iterator2, LongPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(LongIterator iterator2, T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static long sum(LongIterator iterator2) {
        long sum2 = 0L;
        while (iterator2.hasNext()) {
            sum2 += iterator2.next();
        }
        return sum2;
    }

    public static long max(LongIterator iterator2) {
        long max2 = iterator2.next();
        while (iterator2.hasNext()) {
            long next = iterator2.next();
            if (max2 >= next) continue;
            max2 = next;
        }
        return max2;
    }

    public static long min(LongIterator iterator2) {
        long min2 = iterator2.next();
        while (iterator2.hasNext()) {
            long next = iterator2.next();
            if (next >= min2) continue;
            min2 = next;
        }
        return min2;
    }
}

