/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.hibernate.engine.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class PooledConnections {
    private ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();
    private static final CoreMessageLogger log = CoreLogging.messageLogger(DriverManagerConnectionProviderImpl.class);
    private final ConnectionCreator connectionCreator;
    private final boolean autoCommit;
    private final int minSize;
    private final int maxSize;
    private boolean primed;

    private PooledConnections(Builder builder) {
        log.debugf("Initializing Connection pool with %s Connections", builder.initialSize);
        this.connectionCreator = builder.connectionCreator;
        this.autoCommit = builder.autoCommit;
        this.maxSize = builder.maxSize;
        this.minSize = builder.minSize;
        log.hibernateConnectionPoolSize(this.maxSize, this.minSize);
        this.addConnections(builder.initialSize);
    }

    public void validate() {
        int size2 = this.size();
        if (!this.primed && size2 >= this.minSize) {
            log.debug("Connection pool now considered primed; min-size will be maintained");
            this.primed = true;
        }
        if (size2 < this.minSize && this.primed) {
            int numberToBeAdded = this.minSize - size2;
            log.debugf("Adding %s Connections to the pool", numberToBeAdded);
            this.addConnections(numberToBeAdded);
        } else if (size2 > this.maxSize) {
            int numberToBeRemoved = size2 - this.maxSize;
            log.debugf("Removing %s Connections from the pool", numberToBeRemoved);
            this.removeConnections(numberToBeRemoved);
        }
    }

    public void add(Connection conn) throws SQLException {
        conn.setAutoCommit(true);
        conn.clearWarnings();
        this.connections.offer(conn);
    }

    public Connection poll() throws SQLException {
        Connection conn = this.connections.poll();
        if (conn == null) {
            return null;
        }
        conn.setAutoCommit(this.autoCommit);
        return conn;
    }

    public void close() throws SQLException {
        for (Connection connection : this.connections) {
            connection.close();
        }
    }

    public int size() {
        return this.connections.size();
    }

    protected void removeConnections(int numberToBeRemoved) {
        for (int i = 0; i < numberToBeRemoved; ++i) {
            Connection connection = this.connections.poll();
            try {
                if (connection == null) continue;
                connection.close();
                continue;
            }
            catch (SQLException e) {
                log.unableToCloseConnection(e);
            }
        }
    }

    protected void addConnections(int numberOfConnections) {
        for (int i = 0; i < numberOfConnections; ++i) {
            this.connections.add(this.connectionCreator.createConnection());
        }
    }

    public static class Builder {
        private final ConnectionCreator connectionCreator;
        private boolean autoCommit;
        private int initialSize = 1;
        private int minSize = 1;
        private int maxSize = 20;

        public Builder(ConnectionCreator connectionCreator, boolean autoCommit) {
            this.connectionCreator = connectionCreator;
            this.autoCommit = autoCommit;
        }

        public Builder initialSize(int initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public Builder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public PooledConnections build() {
            return new PooledConnections(this);
        }
    }
}

