/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.builder;

import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowBuilderException;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.beans.factory.InitializingBean;

public class JobFlowBuilder
extends FlowBuilder<FlowJobBuilder> {
    private FlowJobBuilder parent;

    public JobFlowBuilder(FlowJobBuilder parent) {
        super(parent.getName());
        this.parent = parent;
    }

    public JobFlowBuilder(FlowJobBuilder parent, Step step) {
        super(parent.getName());
        this.parent = parent;
        this.start(step);
    }

    public JobFlowBuilder(FlowJobBuilder parent, JobExecutionDecider decider) {
        super(parent.getName());
        this.parent = parent;
        this.start(decider);
    }

    public JobFlowBuilder(FlowJobBuilder parent, Flow flow) {
        super(parent.getName());
        this.parent = parent;
        this.start(flow);
    }

    @Override
    public FlowJobBuilder build() {
        Flow flow = this.flow();
        if (flow instanceof InitializingBean) {
            try {
                ((InitializingBean)((Object)flow)).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new FlowBuilderException(e);
            }
        }
        this.parent.flow(flow);
        return this.parent;
    }
}

