/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeJobExecutionListener
implements JobExecutionListener {
    private OrderedComposite<JobExecutionListener> listeners = new OrderedComposite();

    public void setListeners(List<? extends JobExecutionListener> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(JobExecutionListener jobExecutionListener) {
        this.listeners.add(jobExecutionListener);
    }

    @Override
    public void afterJob(JobExecution jobExecution) {
        Iterator<JobExecutionListener> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            JobExecutionListener listener2 = iterator2.next();
            listener2.afterJob(jobExecution);
        }
    }

    @Override
    public void beforeJob(JobExecution jobExecution) {
        Iterator<JobExecutionListener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            JobExecutionListener listener2 = iterator2.next();
            listener2.beforeJob(jobExecution);
        }
    }
}

