/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.classify;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.classify.SubclassClassifier;

public class BinaryExceptionClassifier
extends SubclassClassifier<Throwable, Boolean> {
    private boolean traverseCauses;

    public BinaryExceptionClassifier(boolean defaultValue) {
        super(defaultValue);
    }

    public BinaryExceptionClassifier(Collection<Class<? extends Throwable>> exceptionClasses, boolean value) {
        this(!value);
        if (exceptionClasses != null) {
            HashMap<Class<? extends Throwable>, Boolean> map2 = new HashMap<Class<? extends Throwable>, Boolean>();
            for (Class<? extends Throwable> type : exceptionClasses) {
                map2.put(type, (Boolean)this.getDefault() == false);
            }
            this.setTypeMap(map2);
        }
    }

    public BinaryExceptionClassifier(Collection<Class<? extends Throwable>> exceptionClasses) {
        this(exceptionClasses, true);
    }

    public BinaryExceptionClassifier(Map<Class<? extends Throwable>, Boolean> typeMap) {
        this(typeMap, false);
    }

    public BinaryExceptionClassifier(Map<Class<? extends Throwable>, Boolean> typeMap, boolean defaultValue) {
        super(typeMap, defaultValue);
    }

    public void setTraverseCauses(boolean traverseCauses) {
        this.traverseCauses = traverseCauses;
    }

    @Override
    public Boolean classify(Throwable classifiable) {
        Boolean classified = (Boolean)super.classify(classifiable);
        if (!this.traverseCauses) {
            return classified;
        }
        if (classified.equals(this.getDefault())) {
            Throwable cause = classifiable;
            do {
                if (this.getClassified().containsKey(cause.getClass())) {
                    return classified;
                }
                cause = cause.getCause();
                classified = (Boolean)super.classify(cause);
            } while (cause != null && classified.equals(this.getDefault()));
        }
        return classified;
    }
}

