/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutWrappingEncoder<E>
extends EncoderBase<E> {
    protected Layout<E> layout;
    private Charset charset;
    private boolean immediateFlush = true;

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout2) {
        this.layout = layout2;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void init(OutputStream os) throws IOException {
        super.init(os);
        this.writeHeader();
    }

    void writeHeader() throws IOException {
        if (this.layout != null && this.outputStream != null) {
            StringBuilder sb = new StringBuilder();
            this.appendIfNotNull(sb, this.layout.getFileHeader());
            this.appendIfNotNull(sb, this.layout.getPresentationHeader());
            if (sb.length() > 0) {
                sb.append(CoreConstants.LINE_SEPARATOR);
                this.outputStream.write(this.convertToBytes(sb.toString()));
                this.outputStream.flush();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.writeFooter();
    }

    void writeFooter() throws IOException {
        if (this.layout != null && this.outputStream != null) {
            StringBuilder sb = new StringBuilder();
            this.appendIfNotNull(sb, this.layout.getPresentationFooter());
            this.appendIfNotNull(sb, this.layout.getFileFooter());
            if (sb.length() > 0) {
                this.outputStream.write(this.convertToBytes(sb.toString()));
                this.outputStream.flush();
            }
        }
    }

    private byte[] convertToBytes(String s) {
        if (this.charset == null) {
            return s.getBytes();
        }
        try {
            return s.getBytes(this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("An existing charset cannot possibly be unsupported.");
        }
    }

    @Override
    public void doEncode(E event) throws IOException {
        String txt = this.layout.doLayout(event);
        this.outputStream.write(this.convertToBytes(txt));
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void appendIfNotNull(StringBuilder sb, String s) {
        if (s != null) {
            sb.append(s);
        }
    }
}

