/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.DirectoryWalker;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

public class FileSystemReader
extends StepExecutionSupport
implements ItemReader<File> {
    private SimpleDirectoryWalker walker;
    private File rootDirectory = null;

    public FileSystemReader(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    @Override
    public synchronized File read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        if (this.walker == null) {
            this.walker = new SimpleDirectoryWalker(this.rootDirectory);
            this.walker.start();
            long itemsRead = this.getItemsRead();
            if (itemsRead > 0L) {
                int i = 0;
                while ((long)i < itemsRead) {
                    this.walker.next();
                    ++i;
                }
            }
        }
        return this.walker.next();
    }

    private class SimpleDirectoryWalker
    extends DirectoryWalker<File> {
        private SynchronousQueue<File> queue = new SynchronousQueue();
        private File root;

        public SimpleDirectoryWalker(File root) {
            this.root = root;
        }

        public void start() {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SimpleDirectoryWalker.this.walk(SimpleDirectoryWalker.this.root, SimpleDirectoryWalker.this.queue);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            t.start();
        }

        @Override
        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            try {
                if (file.isFile()) {
                    this.queue.put(file);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public File next() {
            try {
                return this.queue.poll(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

