/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.strategy.mutable;

import java.io.Serializable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.bag.mutable.AbstractHashBag;
import org.eclipse.collections.impl.bag.strategy.mutable.HashBagWithHashingStrategySerializationProxy;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMapWithHashingStrategy;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBagWithHashingStrategy<T>
extends AbstractHashBag<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashingStrategy<? super T> hashingStrategy;

    public HashBagWithHashingStrategy(HashingStrategy<? super T> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Cannot Instantiate HashBagWithHashingStrategy with null HashingStrategy");
        }
        this.hashingStrategy = hashingStrategy;
        this.items = ObjectIntHashMapWithHashingStrategy.newMap(hashingStrategy);
    }

    public HashBagWithHashingStrategy(HashingStrategy<? super T> hashingStrategy, int size2) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Cannot Instantiate HashBagWithHashingStrategy with null HashingStrategy");
        }
        this.hashingStrategy = hashingStrategy;
        this.items = new ObjectIntHashMapWithHashingStrategy<T>(hashingStrategy, size2);
    }

    private HashBagWithHashingStrategy(HashingStrategy<? super T> hashingStrategy, MutableObjectIntMap<T> map2) {
        this.hashingStrategy = hashingStrategy;
        this.items = map2;
        this.size = (int)map2.sum();
    }

    public static <E> HashBagWithHashingStrategy<E> newBag(HashingStrategy<? super E> hashingStrategy) {
        return new HashBagWithHashingStrategy<E>(hashingStrategy);
    }

    public static <E> HashBagWithHashingStrategy<E> newBag(HashingStrategy<? super E> hashingStrategy, int size2) {
        return new HashBagWithHashingStrategy<E>(hashingStrategy, size2);
    }

    public static <E> HashBagWithHashingStrategy<E> newBag(HashingStrategy<? super E> hashingStrategy, Bag<? extends E> source) {
        HashBagWithHashingStrategy<E> result = HashBagWithHashingStrategy.newBag(hashingStrategy, source.sizeDistinct());
        result.addAllBag(source);
        return result;
    }

    public static <E> HashBagWithHashingStrategy<E> newBag(HashingStrategy<? super E> hashingStrategy, Iterable<? extends E> source) {
        if (source instanceof Bag) {
            return HashBagWithHashingStrategy.newBag(hashingStrategy, (Bag)source);
        }
        return HashBagWithHashingStrategy.newBagWith(hashingStrategy, Iterate.toArray(source));
    }

    public static <E> HashBagWithHashingStrategy<E> newBagWith(HashingStrategy<? super E> hashingStrategy, E ... elements) {
        HashBagWithHashingStrategy<? super E> result = HashBagWithHashingStrategy.newBag(hashingStrategy);
        ArrayIterate.addAllTo(elements, result);
        return result;
    }

    public HashingStrategy<? super T> hashingStrategy() {
        return this.hashingStrategy;
    }

    @Override
    protected int computeHashCode(T item) {
        return this.hashingStrategy.computeHashCode(item);
    }

    @Override
    public MutableBag<T> selectByOccurrences(final IntPredicate predicate) {
        MutableObjectIntMap map2 = this.items.select(new ObjectIntPredicate<T>(){

            @Override
            public boolean accept(T each2, int occurrences) {
                return predicate.accept(occurrences);
            }
        });
        return new HashBagWithHashingStrategy<T>(this.hashingStrategy, map2);
    }

    protected Object writeReplace() {
        return new HashBagWithHashingStrategySerializationProxy(this);
    }

    @Override
    public MutableBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public MutableBag<T> newEmpty() {
        return HashBagWithHashingStrategy.newBag(this.hashingStrategy);
    }
}

