/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.forkjoin;

import java.util.concurrent.ForkJoinTask;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.forkjoin.FJBatchIterableProcedureRunner;
import org.eclipse.collections.impl.parallel.BatchIterable;
import org.eclipse.collections.impl.parallel.ProcedureFactory;

public class FJBatchIterableProcedureTask<T, PT extends Procedure<? super T>>
extends ForkJoinTask<PT> {
    private static final long serialVersionUID = 1L;
    private final ProcedureFactory<PT> procedureFactory;
    private PT procedure;
    private final BatchIterable<T> iterable;
    private final int sectionIndex;
    private final int sectionCount;
    private final FJBatchIterableProcedureRunner<T, PT> taskRunner;

    public FJBatchIterableProcedureTask(FJBatchIterableProcedureRunner<T, PT> newFJTaskRunner, ProcedureFactory<PT> newProcedureFactory, BatchIterable<T> iterable, int index, int count2) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = newProcedureFactory;
        this.iterable = iterable;
        this.sectionIndex = index;
        this.sectionCount = count2;
    }

    @Override
    protected boolean exec() {
        try {
            this.procedure = this.procedureFactory.create();
            this.iterable.batchForEach((Procedure<T>)this.procedure, this.sectionIndex, this.sectionCount);
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
        return true;
    }

    @Override
    public PT getRawResult() {
        return this.procedure;
    }

    @Override
    protected void setRawResult(PT value) {
        throw new UnsupportedOperationException();
    }
}

