/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.TapIterator;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TapIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final Procedure<? super T> procedure;

    public TapIterable(Iterable<T> newAdapted, Procedure<? super T> procedure) {
        this.adapted = newAdapted;
        this.procedure = procedure;
    }

    @Override
    public void each(final Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, new Procedure<T>(){

            @Override
            public void value(T each2) {
                TapIterable.this.procedure.value(each2);
                procedure.value(each2);
            }
        });
    }

    @Override
    public void forEachWithIndex(final ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, new ObjectIntProcedure<T>(){

            @Override
            public void value(T each2, int index) {
                TapIterable.this.procedure.value(each2);
                objectIntProcedure.value(each2, index);
            }
        });
    }

    @Override
    public <P> void forEachWith(final Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, new Procedure2<T, P>(){

            @Override
            public void value(T each2, P aParameter) {
                TapIterable.this.procedure.value(each2);
                procedure.value(each2, aParameter);
            }
        }, parameter);
    }

    @Override
    public boolean anySatisfy(final Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                TapIterable.this.procedure.value(each2);
                return predicate.accept(each2);
            }
        });
    }

    @Override
    public boolean allSatisfy(final Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                TapIterable.this.procedure.value(each2);
                return predicate.accept(each2);
            }
        });
    }

    @Override
    public boolean noneSatisfy(final Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                TapIterable.this.procedure.value(each2);
                return predicate.accept(each2);
            }
        });
    }

    @Override
    public T getFirst() {
        return Iterate.detect(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                TapIterable.this.procedure.value(each2);
                return true;
            }
        });
    }

    @Override
    public T detect(final Predicate<? super T> predicate) {
        return Iterate.detect(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                TapIterable.this.procedure.value(each2);
                return predicate.accept(each2);
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return new TapIterator<T>(this.adapted, this.procedure);
    }
}

