/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.DoubleObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.DoubleObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleObjectMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleObjectMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionIterable;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableDoubleObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleObjectHashMap<V>
extends AbstractImmutableDoubleObjectMap<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleObjectMap<V> delegate;

    ImmutableDoubleObjectHashMap(DoubleObjectMap<? extends V> delegate) {
        this.delegate = new DoubleObjectHashMap<V>(delegate);
    }

    @Override
    public V get(double key) {
        return this.delegate.get(key);
    }

    @Override
    public V getIfAbsent(double key, Function0<? extends V> ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public ImmutableDoubleObjectMap<V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(DoubleObjectProcedure<? super V> procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public ImmutableDoubleObjectMap<V> select(DoubleObjectPredicate<? super V> predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableDoubleObjectMap<V> reject(DoubleObjectPredicate<? super V> predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public ImmutableDoubleObjectMap<V> toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public V getFirst() {
        return (V)this.delegate.getFirst();
    }

    @Override
    public V getLast() {
        return (V)this.delegate.getLast();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public boolean containsAllIterable(Iterable<?> source) {
        return this.delegate.containsAllIterable(source);
    }

    @Override
    public boolean containsAll(Collection<?> source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAllArguments(Object ... elements) {
        return this.delegate.containsAllArguments(elements);
    }

    @Override
    public ImmutableCollection<V> select(Predicate<? super V> predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return this.delegate.select(predicate, target);
    }

    @Override
    public <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.selectWith(predicate, parameter).toImmutable();
    }

    @Override
    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return this.delegate.selectWith(predicate, parameter, targetCollection);
    }

    @Override
    public ImmutableCollection<V> reject(Predicate<? super V> predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return this.delegate.reject(predicate, target);
    }

    @Override
    public <P> ImmutableCollection<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.rejectWith(predicate, parameter).toImmutable();
    }

    @Override
    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return this.delegate.rejectWith(predicate, parameter, targetCollection);
    }

    @Override
    public PartitionIterable<V> partition(Predicate<? super V> predicate) {
        return this.delegate.partition(predicate);
    }

    @Override
    public <P> PartitionIterable<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.partitionWith(predicate, parameter);
    }

    @Override
    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.delegate.selectInstancesOf(clazz);
    }

    @Override
    public <VV> ImmutableCollection<VV> collect(Function<? super V, ? extends VV> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.delegate.collectBoolean(booleanFunction).toImmutable();
    }

    @Override
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        return this.delegate.collectBoolean(booleanFunction, target);
    }

    @Override
    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction) {
        return this.delegate.collectByte(byteFunction).toImmutable();
    }

    @Override
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        return this.delegate.collectByte(byteFunction, target);
    }

    @Override
    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction) {
        return this.delegate.collectChar(charFunction).toImmutable();
    }

    @Override
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        return this.delegate.collectChar(charFunction, target);
    }

    @Override
    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.delegate.collectDouble(doubleFunction).toImmutable();
    }

    @Override
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        return this.delegate.collectDouble(doubleFunction, target);
    }

    @Override
    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction) {
        return this.delegate.collectFloat(floatFunction).toImmutable();
    }

    @Override
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        return this.delegate.collectFloat(floatFunction, target);
    }

    @Override
    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction) {
        return this.delegate.collectInt(intFunction).toImmutable();
    }

    @Override
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        return this.delegate.collectInt(intFunction, target);
    }

    @Override
    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction) {
        return this.delegate.collectLong(longFunction).toImmutable();
    }

    @Override
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        return this.delegate.collectLong(longFunction, target);
    }

    @Override
    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction) {
        return this.delegate.collectShort(shortFunction).toImmutable();
    }

    @Override
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        return this.delegate.collectShort(shortFunction, target);
    }

    @Override
    public <P, VV> ImmutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.delegate.collectWith(function, parameter).toImmutable();
    }

    @Override
    public <VV> RichIterable<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.delegate.collectIf(predicate, function);
    }

    @Override
    public <VV> RichIterable<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.flatCollect(function);
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        return this.delegate.detect(predicate);
    }

    @Override
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.detectWith(predicate, parameter);
    }

    @Override
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return this.delegate.detectIfNone(predicate, function);
    }

    @Override
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return this.delegate.detectWithIfNone(predicate, parameter, function);
    }

    @Override
    public int count(Predicate<? super V> predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.countWith(predicate, parameter);
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.anySatisfyWith(predicate, parameter);
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.allSatisfyWith(predicate, parameter);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.noneSatisfyWith(predicate, parameter);
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public MutableList<V> toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableList<V> toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.delegate.toSortedList(comparator);
    }

    @Override
    public MutableSet<V> toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableSortedSet<V> toSortedSet() {
        return this.delegate.toSortedSet();
    }

    @Override
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.delegate.toSortedSet(comparator);
    }

    @Override
    public MutableBag<V> toBag() {
        return this.delegate.toBag();
    }

    @Override
    public MutableSortedBag<V> toSortedBag() {
        return this.delegate.toSortedBag();
    }

    @Override
    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return this.delegate.toSortedBag(comparator);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedBagBy(function);
    }

    @Override
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toMap(keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(keyFunction, valueFunction);
    }

    @Override
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
    }

    @Override
    public LazyIterable<V> asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public V min(Comparator<? super V> comparator) {
        return this.delegate.min(comparator);
    }

    @Override
    public V max(Comparator<? super V> comparator) {
        return this.delegate.max(comparator);
    }

    @Override
    public V min() {
        return (V)this.delegate.min();
    }

    @Override
    public V max() {
        return (V)this.delegate.max();
    }

    @Override
    public long sumOfInt(IntFunction<? super V> function) {
        return this.delegate.sumOfInt(function);
    }

    @Override
    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.delegate.sumOfFloat(function);
    }

    @Override
    public long sumOfLong(LongFunction<? super V> function) {
        return this.delegate.sumOfLong(function);
    }

    @Override
    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.delegate.sumOfDouble(function);
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public <VV> Multimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.delegate.groupBy(function);
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        return this.delegate.groupBy(function, target);
    }

    @Override
    public <VV> Multimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.delegate.groupByEach(function);
    }

    @Override
    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return this.delegate.groupByEach(function, target);
    }

    @Override
    public <VV> MapIterable<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.delegate.groupByUniqueKey(function);
    }

    @Override
    public <VV, R extends MutableMap<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        return this.delegate.groupByUniqueKey(function, target);
    }

    @Override
    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that) {
        return this.delegate.zip(that);
    }

    @Override
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return this.delegate.zip(that, target);
    }

    @Override
    public RichIterable<Pair<V, Integer>> zipWithIndex() {
        return this.delegate.zipWithIndex();
    }

    @Override
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return this.delegate.zipWithIndex(target);
    }

    @Override
    public RichIterable<RichIterable<V>> chunk(int size2) {
        return this.delegate.chunk(size2);
    }

    @Override
    public <K, VV> MapIterable<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    @Override
    public <K, VV> MapIterable<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    @Override
    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return this.delegate.maxBy(function);
    }

    @Override
    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return this.delegate.minBy(function);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedSetBy(function);
    }

    @Override
    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedListBy(function);
    }

    @Override
    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return this.delegate.flatCollect(function, target);
    }

    @Override
    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        return this.delegate.collectIf(predicate, function, target);
    }

    @Override
    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        return this.delegate.collectWith(function, parameter, targetCollection);
    }

    @Override
    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        return this.delegate.collect(function, target);
    }

    @Override
    public ImmutableDoubleObjectMap<V> newWithKeyValue(double key, V value) {
        DoubleObjectHashMap<V> map2 = new DoubleObjectHashMap<V>(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableDoubleObjectMap<V> newWithoutKey(double key) {
        DoubleObjectHashMap map2 = new DoubleObjectHashMap(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableDoubleObjectMap<V> newWithoutAllKeys(DoubleIterable keys) {
        DoubleObjectHashMap map2 = new DoubleObjectHashMap(this);
        DoubleIterator iterator2 = keys.doubleIterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    @Override
    public void each(Procedure<? super V> procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.delegate.forEachWithIndex(objectIntProcedure);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.delegate.forEachWith(procedure, parameter);
    }

    @Override
    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter(this.delegate.iterator());
    }

    @Override
    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    @Override
    public Collection<V> values() {
        return UnmodifiableMutableCollection.of(this.delegate.values());
    }

    @Override
    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<DoubleObjectPair<V>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new AbstractImmutableDoubleObjectMap.ImmutableDoubleObjectMapSerializationProxy(this);
    }
}

