/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectCharMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectCharEmptyMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableObjectCharSingletonMap<K>
extends AbstractImmutableObjectCharMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';
    private final K key1;
    private final char value1;

    ImmutableObjectCharSingletonMap(K key1, char value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(ObjectCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator());
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(CharPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableCharCollection select(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharLists.immutable.with(this.value1) : CharLists.immutable.with();
    }

    @Override
    public ImmutableCharCollection reject(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharLists.immutable.with() : CharLists.immutable.with(this.value1);
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public char min() {
        return this.value1;
    }

    @Override
    public char max() {
        return this.value1;
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.value1;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public char[] toSortedArray() {
        return new char[]{this.value1};
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.value1);
    }

    @Override
    public char[] toArray() {
        return new char[]{this.value1};
    }

    @Override
    public boolean contains(char value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator2 = source.charIterator();
        while (iterator2.hasNext()) {
            if (this.value1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newListWith(this.value1);
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public ImmutableObjectCharMap<K> newWithKeyValue(K key, char value) {
        return ObjectCharMaps.immutable.withAll(ObjectCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableObjectCharMap<K> newWithoutKey(K key) {
        return ImmutableObjectCharSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectCharEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    @Override
    public ImmutableObjectCharMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectCharHashMap<K> map2 = new ObjectCharHashMap<K>(this);
        for (K key : keys) {
            map2.removeKey(key);
        }
        return map2.toImmutable();
    }

    @Override
    public char get(Object key) {
        return this.getIfAbsent(key, '\u0000');
    }

    @Override
    public char getOrThrow(Object key) {
        if (ImmutableObjectCharSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public char getIfAbsent(Object key, char ifAbsent) {
        return ImmutableObjectCharSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        return ImmutableObjectCharSingletonMap.nullSafeEquals(this.key1, key);
    }

    @Override
    public boolean containsValue(char value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(ObjectCharProcedure<? super K> objectCharProcedure) {
        objectCharProcedure.value(this.key1, this.value1);
    }

    @Override
    public ImmutableObjectCharMap<K> select(ObjectCharPredicate<? super K> objectCharPredicate) {
        return objectCharPredicate.accept(this.key1, this.value1) ? ObjectCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectCharEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> objectCharPredicate) {
        return objectCharPredicate.accept(this.key1, this.value1) ? ImmutableObjectCharEmptyMap.INSTANCE : ObjectCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public ImmutableObjectCharMap<K> toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    @Override
    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(CharArrayList.newListWith(this.value1));
    }

    @Override
    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<ObjectCharPair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectCharMap)) {
            return false;
        }
        ObjectCharMap map2 = (ObjectCharMap)obj;
        if (map2.size() != 1) {
            return false;
        }
        return map2.containsKey(this.key1) && this.value1 == map2.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectCharMap.ImmutableObjectCharMapSerializationProxy(this);
    }
}

