/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableSetSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ImmutableSet<T> set;

    public ImmutableSetSerializationProxy() {
    }

    ImmutableSetSerializationProxy(ImmutableSet<T> set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedProcedure<T>(){

                @Override
                public void safeValue(T value) throws IOException {
                    out.writeObject(value);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        UnifiedSet deserializedSet = UnifiedSet.newSet(size2);
        for (int i = 0; i < size2; ++i) {
            deserializedSet.add(in.readObject());
        }
        this.set = deserializedSet.toImmutable();
    }

    protected Object readResolve() {
        return this.set;
    }
}

