/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.AttributeConverterAutoApplyHandler;
import org.hibernate.boot.spi.AttributeConverterDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class AttributeConverterManager
implements AttributeConverterAutoApplyHandler {
    private static final Logger log = Logger.getLogger(AttributeConverterManager.class);
    private Map<Class, AttributeConverterDescriptor> attributeConverterDescriptorsByClass;
    private static StringHelper.Renderer<AttributeConverterDescriptor> RENDERER = new StringHelper.Renderer<AttributeConverterDescriptor>(){

        @Override
        public String render(AttributeConverterDescriptor value) {
            return value.getAttributeConverter().getClass().getName();
        }
    };

    void addConverter(AttributeConverterDescriptor descriptor) {
        AttributeConverterDescriptor old;
        if (this.attributeConverterDescriptorsByClass == null) {
            this.attributeConverterDescriptorsByClass = new ConcurrentHashMap<Class, AttributeConverterDescriptor>();
        }
        if ((old = this.attributeConverterDescriptorsByClass.put(descriptor.getAttributeConverter().getClass(), descriptor)) != null) {
            throw new AssertionFailure(String.format(Locale.ENGLISH, "AttributeConverter class [%s] registered multiple times", descriptor.getAttributeConverter().getClass()));
        }
    }

    private Collection<AttributeConverterDescriptor> converterDescriptors() {
        if (this.attributeConverterDescriptorsByClass == null) {
            return Collections.emptyList();
        }
        return this.attributeConverterDescriptorsByClass.values();
    }

    @Override
    public AttributeConverterDescriptor findAutoApplyConverterForAttribute(XProperty xProperty, MetadataBuildingContext context) {
        ArrayList<AttributeConverterDescriptor> matched = new ArrayList<AttributeConverterDescriptor>();
        for (AttributeConverterDescriptor descriptor : this.converterDescriptors()) {
            log.debugf("Checking auto-apply AttributeConverter [%s] (type=%s) for match against attribute : %s.%s (type=%s)", descriptor.toString(), descriptor.getDomainType().getSimpleName(), xProperty.getDeclaringClass().getName(), xProperty.getName(), xProperty.getType().getName());
            if (!descriptor.shouldAutoApplyToAttribute(xProperty, context)) continue;
            matched.add(descriptor);
        }
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() == 1) {
            return (AttributeConverterDescriptor)matched.get(0);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Multiple auto-apply converters matched attribute [%s.%s] : %s", xProperty.getDeclaringClass().getName(), xProperty.getName(), StringHelper.join(matched, RENDERER)));
    }

    @Override
    public AttributeConverterDescriptor findAutoApplyConverterForCollectionElement(XProperty xProperty, MetadataBuildingContext context) {
        ArrayList<AttributeConverterDescriptor> matched = new ArrayList<AttributeConverterDescriptor>();
        for (AttributeConverterDescriptor descriptor : this.converterDescriptors()) {
            log.debugf("Checking auto-apply AttributeConverter [%s] (type=%s) for match against collection attribute's element : %s.%s (type=%s)", descriptor.toString(), descriptor.getDomainType().getSimpleName(), xProperty.getDeclaringClass().getName(), xProperty.getName(), xProperty.getElementClass().getName());
            if (!descriptor.shouldAutoApplyToCollectionElement(xProperty, context)) continue;
            matched.add(descriptor);
        }
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() == 1) {
            return (AttributeConverterDescriptor)matched.get(0);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Multiple auto-apply converters matched attribute [%s.%s] : %s", xProperty.getDeclaringClass().getName(), xProperty.getName(), StringHelper.join(matched, RENDERER)));
    }

    @Override
    public AttributeConverterDescriptor findAutoApplyConverterForMapKey(XProperty xProperty, MetadataBuildingContext context) {
        ArrayList<AttributeConverterDescriptor> matched = new ArrayList<AttributeConverterDescriptor>();
        for (AttributeConverterDescriptor descriptor : this.converterDescriptors()) {
            log.debugf("Checking auto-apply AttributeConverter [%s] (type=%s) for match against map attribute's key : %s.%s (type=%s)", descriptor.toString(), descriptor.getDomainType().getSimpleName(), xProperty.getDeclaringClass().getName(), xProperty.getName(), xProperty.getMapKey().getName());
            if (!descriptor.shouldAutoApplyToMapKey(xProperty, context)) continue;
            matched.add(descriptor);
        }
        if (matched.isEmpty()) {
            return null;
        }
        if (matched.size() == 1) {
            return (AttributeConverterDescriptor)matched.get(0);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Multiple auto-apply converters matched attribute [%s.%s] : %s", xProperty.getDeclaringClass().getName(), xProperty.getName(), StringHelper.join(matched, RENDERER)));
    }
}

