/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class BatchFetchQueue {
    private static final Logger LOG = CoreLogging.logger(BatchFetchQueue.class);
    private final PersistenceContext context;
    private final Map<EntityKey, SubselectFetch> subselectsByEntityKey = new HashMap<EntityKey, SubselectFetch>(8);
    private final Map<String, LinkedHashSet<EntityKey>> batchLoadableEntityKeys = new HashMap<String, LinkedHashSet<EntityKey>>(8);
    private final Map<String, LinkedHashMap<CollectionEntry, PersistentCollection>> batchLoadableCollections = new HashMap<String, LinkedHashMap<CollectionEntry, PersistentCollection>>(8);

    public BatchFetchQueue(PersistenceContext context) {
        this.context = context;
    }

    public void clear() {
        this.batchLoadableEntityKeys.clear();
        this.batchLoadableCollections.clear();
        this.subselectsByEntityKey.clear();
    }

    public SubselectFetch getSubselect(EntityKey key) {
        return this.subselectsByEntityKey.get(key);
    }

    public void addSubselect(EntityKey key, SubselectFetch subquery) {
        this.subselectsByEntityKey.put(key, subquery);
    }

    public void removeSubselect(EntityKey key) {
        this.subselectsByEntityKey.remove(key);
    }

    public void addBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable()) {
            LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(key.getEntityName());
            if (set == null) {
                set = new LinkedHashSet(8);
                this.batchLoadableEntityKeys.put(key.getEntityName(), set);
            }
            set.add(key);
        }
    }

    public void removeBatchLoadableEntityKey(EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable() && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            set.remove(key);
        }
    }

    public boolean containsEntityKey(EntityKey key) {
        LinkedHashSet<EntityKey> set;
        if (key.isBatchLoadable() && (set = this.batchLoadableEntityKeys.get(key.getEntityName())) != null) {
            return set.contains(key);
        }
        return false;
    }

    public Serializable[] getEntityBatch(EntityPersister persister, Serializable id, int batchSize, EntityMode entityMode) {
        Serializable[] ids = new Serializable[batchSize];
        ids[0] = id;
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashSet<EntityKey> set = this.batchLoadableEntityKeys.get(persister.getEntityName());
        if (set != null) {
            for (EntityKey key : set) {
                if (checkForEnd && i == end) {
                    return ids;
                }
                if (persister.getIdentifierType().isEqual(id, key.getIdentifier())) {
                    end = i;
                } else if (!this.isCached(key, persister)) {
                    ids[i++] = key.getIdentifier();
                }
                if (i != batchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return ids;
    }

    private boolean isCached(EntityKey entityKey, EntityPersister persister) {
        SessionImplementor session = this.context.getSession();
        if (this.context.getSession().getCacheMode().isGetEnabled() && persister.hasCache()) {
            EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            Object key = cache.generateCacheKey(entityKey.getIdentifier(), persister, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, key, cache) != null;
        }
        return false;
    }

    public void addBatchLoadableCollection(PersistentCollection collection, CollectionEntry ce) {
        CollectionPersister persister = ce.getLoadedPersister();
        LinkedHashMap<CollectionEntry, PersistentCollection> map2 = this.batchLoadableCollections.get(persister.getRole());
        if (map2 == null) {
            map2 = new LinkedHashMap(16);
            this.batchLoadableCollections.put(persister.getRole(), map2);
        }
        map2.put(ce, collection);
    }

    public void removeBatchLoadableCollection(CollectionEntry ce) {
        LinkedHashMap<CollectionEntry, PersistentCollection> map2 = this.batchLoadableCollections.get(ce.getLoadedPersister().getRole());
        if (map2 != null) {
            map2.remove(ce);
        }
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable id, int batchSize) {
        Serializable[] keys = new Serializable[batchSize];
        keys[0] = id;
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        LinkedHashMap<CollectionEntry, PersistentCollection> map2 = this.batchLoadableCollections.get(collectionPersister.getRole());
        if (map2 != null) {
            for (Map.Entry<CollectionEntry, PersistentCollection> me : map2.entrySet()) {
                CollectionEntry ce = me.getKey();
                PersistentCollection collection = me.getValue();
                if (ce.getLoadedKey() == null) continue;
                if (collection.wasInitialized()) {
                    LOG.warn("Encountered initialized collection in BatchFetchQueue, this should not happen.");
                    continue;
                }
                if (checkForEnd && i == end) {
                    return keys;
                }
                boolean isEqual = collectionPersister.getKeyType().isEqual(id, ce.getLoadedKey(), collectionPersister.getFactory());
                if (isEqual) {
                    end = i;
                } else if (!this.isCached(ce.getLoadedKey(), collectionPersister)) {
                    keys[i++] = ce.getLoadedKey();
                }
                if (i != batchSize) continue;
                i = 1;
                if (end == -1) continue;
                checkForEnd = true;
            }
        }
        return keys;
    }

    private boolean isCached(Serializable collectionKey, CollectionPersister persister) {
        SessionImplementor session = this.context.getSession();
        if (session.getCacheMode().isGetEnabled() && persister.hasCache()) {
            CollectionRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            Object cacheKey = cache.generateCacheKey(collectionKey, persister, session.getFactory(), session.getTenantIdentifier());
            return CacheHelper.fromSharedCache(session, cacheKey, cache) != null;
        }
        return false;
    }
}

