/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class WrapVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(WrapVisitor.class);
    boolean substitute;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            EventSource session = this.getSession();
            if (coll.setCurrentSession(session)) {
                this.reattachCollection(coll, collectionType);
            }
            return null;
        }
        return this.processArrayOrNewCollection(collection, collectionType);
    }

    final Object processArrayOrNewCollection(Object collection, CollectionType collectionType) throws HibernateException {
        EventSource session = this.getSession();
        if (collection == null) {
            return null;
        }
        CollectionPersister persister = session.getFactory().getCollectionPersister(collectionType.getRole());
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (collectionType.hasHolder()) {
            if (collection == CollectionType.UNFETCHED_COLLECTION) {
                return null;
            }
            PersistentCollection ah = persistenceContext.getCollectionHolder(collection);
            if (ah == null) {
                ah = collectionType.wrap(session, collection);
                persistenceContext.addNewCollection(persister, ah);
                persistenceContext.addCollectionHolder(ah);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(session, collection);
        persistenceContext.addNewCollection(persister, persistentCollection);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Wrapped collection in role: {0}", (Object)collectionType.getRole());
        }
        return persistentCollection;
    }

    @Override
    void processValue(int i, Object[] values2, Type[] types) {
        Object result = this.processValue(values2[i], types[i]);
        if (result != null) {
            this.substitute = true;
            values2[i] = result;
        }
    }

    @Override
    Object processComponent(Object component, CompositeType componentType) throws HibernateException {
        if (component != null) {
            Object[] values2 = componentType.getPropertyValues(component, this.getSession());
            Type[] types = componentType.getSubtypes();
            boolean substituteComponent = false;
            for (int i = 0; i < types.length; ++i) {
                Object result = this.processValue(values2[i], types[i]);
                if (result == null) continue;
                values2[i] = result;
                substituteComponent = true;
            }
            if (substituteComponent) {
                componentType.setPropertyValues(component, values2, EntityMode.POJO);
            }
        }
        return null;
    }

    @Override
    void process(Object object, EntityPersister persister) throws HibernateException {
        Object[] values2 = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        this.processEntityPropertyValues(values2, types);
        if (this.isSubstitutionRequired()) {
            persister.setPropertyValues(object, values2);
        }
    }
}

