/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.volume.ByteBufferVol;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public final class ByteBufferMemoryVol
extends ByteBufferVol {
    public static final VolumeFactory FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            return new ByteBufferMemoryVol(true, sliceShift, false, initSize);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return false;
        }

        @Override
        public boolean handlesReadonly() {
            return false;
        }
    };
    public static final VolumeFactory FACTORY_WITH_CLEANER_HACK = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            return new ByteBufferMemoryVol(true, sliceShift, true, initSize);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return false;
        }

        @Override
        public boolean handlesReadonly() {
            return false;
        }
    };
    protected final boolean useDirectBuffer;

    public String toString() {
        return super.toString() + ",direct=" + this.useDirectBuffer;
    }

    public ByteBufferMemoryVol(boolean useDirectBuffer, int sliceShift, boolean cleanerHackEnabled, long initSize) {
        super(false, sliceShift, cleanerHackEnabled);
        this.useDirectBuffer = useDirectBuffer;
        if (initSize != 0L) {
            this.ensureAvailable(initSize);
        }
    }

    @Override
    public final void ensureAvailable(long offset) {
        int slicePos = (int)((offset = DataIO.roundUp(offset, 1L << this.sliceShift)) >>> this.sliceShift);
        if (slicePos < this.slices.length) {
            return;
        }
        this.growLock.lock();
        try {
            if (slicePos <= this.slices.length) {
                return;
            }
            int oldSize = this.slices.length;
            ByteBuffer[] slices2 = this.slices;
            slices2 = Arrays.copyOf(slices2, slicePos);
            for (int pos = oldSize; pos < slices2.length; ++pos) {
                ByteBuffer b;
                ByteBuffer byteBuffer = b = this.useDirectBuffer ? ByteBuffer.allocateDirect(this.sliceSize) : ByteBuffer.allocate(this.sliceSize);
                if (b.order() != ByteOrder.BIG_ENDIAN) {
                    throw new AssertionError((Object)"little-endian");
                }
                slices2[pos] = b;
            }
            this.slices = slices2;
        }
        catch (OutOfMemoryError e) {
            throw new DBException.OutOfMemory(e);
        }
        finally {
            this.growLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long size2) {
        int maxSize = 1 + (int)(size2 >>> this.sliceShift);
        if (maxSize == this.slices.length) {
            return;
        }
        if (maxSize > this.slices.length) {
            this.ensureAvailable(size2);
            return;
        }
        this.growLock.lock();
        try {
            if (maxSize >= this.slices.length) {
                return;
            }
            ByteBuffer[] old = this.slices;
            this.slices = Arrays.copyOf(this.slices, maxSize);
            for (int i = maxSize; i < old.length; ++i) {
                if (this.cleanerHackEnabled && old[i] instanceof MappedByteBuffer) {
                    ByteBufferMemoryVol.unmap((MappedByteBuffer)old[i]);
                }
                old[i] = null;
            }
        }
        finally {
            this.growLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.growLock.lock();
        try {
            if (this.cleanerHackEnabled) {
                for (ByteBuffer b : this.slices) {
                    if (b == null || !(b instanceof MappedByteBuffer)) continue;
                    ByteBufferMemoryVol.unmap((MappedByteBuffer)b);
                }
            }
            Arrays.fill(this.slices, null);
            this.slices = null;
        }
        finally {
            this.growLock.unlock();
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public long length() {
        return (long)this.slices.length * (long)this.sliceSize;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public boolean getFileLocked() {
        return false;
    }
}

