/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.listener.OrderedComposite;
import org.springframework.batch.core.scope.context.ChunkContext;

public class CompositeChunkListener
implements ChunkListener {
    private OrderedComposite<ChunkListener> listeners = new OrderedComposite();

    public void setListeners(List<? extends ChunkListener> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(ChunkListener chunkListener) {
        this.listeners.add(chunkListener);
    }

    @Override
    public void afterChunk(ChunkContext context) {
        Iterator<ChunkListener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            ChunkListener listener2 = iterator2.next();
            listener2.afterChunk(context);
        }
    }

    @Override
    public void beforeChunk(ChunkContext context) {
        Iterator<ChunkListener> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            ChunkListener listener2 = iterator2.next();
            listener2.beforeChunk(context);
        }
    }

    @Override
    public void afterChunkError(ChunkContext context) {
        Iterator<ChunkListener> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            ChunkListener listener2 = iterator2.next();
            listener2.afterChunkError(context);
        }
    }
}

