/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.amqp;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.batch.item.ItemWriter;
import org.springframework.util.Assert;

public class AmqpItemWriter<T>
implements ItemWriter<T> {
    private final AmqpTemplate amqpTemplate;
    private final Log log = LogFactory.getLog(this.getClass());

    public AmqpItemWriter(AmqpTemplate amqpTemplate) {
        Assert.notNull(amqpTemplate, "AmpqTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Writing to AMQP with " + items.size() + " items.");
        }
        for (T item : items) {
            this.amqpTemplate.convertAndSend(item);
        }
    }
}

