/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoItemReader<T>
extends AbstractPaginatedDataItemReader<T>
implements InitializingBean {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private MongoOperations template;
    private String query;
    private Class<? extends T> type;
    private Sort sort;
    private String hint;
    private String fields;
    private String collection;
    private List<Object> parameterValues;

    public MongoItemReader() {
        this.setName(ClassUtils.getShortName(MongoItemReader.class));
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setTargetType(Class<? extends T> type) {
        this.type = type;
    }

    public void setParameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setSort(Map<String, Sort.Direction> sorts) {
        this.sort = this.convertToSort(sorts);
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    protected Iterator<T> doPageRead() {
        PageRequest pageRequest = new PageRequest(this.page, this.pageSize, this.sort);
        String populatedQuery = this.replacePlaceholders(this.query, this.parameterValues);
        BasicQuery mongoQuery = null;
        mongoQuery = StringUtils.hasText(this.fields) ? new BasicQuery(populatedQuery, this.fields) : new BasicQuery(populatedQuery);
        mongoQuery.with((Pageable)pageRequest);
        if (StringUtils.hasText(this.hint)) {
            mongoQuery.withHint(this.hint);
        }
        if (StringUtils.hasText(this.collection)) {
            return this.template.find((Query)mongoQuery, this.type, this.collection).iterator();
        }
        return this.template.find((Query)mongoQuery, this.type).iterator();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.template != null, "An implementation of MongoOperations is required.");
        Assert.state(this.type != null, "A type to convert the input into is required.");
        Assert.state(this.query != null, "A query is required.");
        Assert.state(this.sort != null, "A sort is required.");
    }

    private String replacePlaceholders(String input, List<Object> values2) {
        Matcher matcher = PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            result = result.replace(group, this.getParameterWithIndex(values2, index));
        }
        return result;
    }

    private String getParameterWithIndex(List<Object> values2, int index) {
        return JSON.serialize((Object)values2.get(index));
    }

    private Sort convertToSort(Map<String, Sort.Direction> sorts) {
        ArrayList<Sort.Order> sortValues = new ArrayList<Sort.Order>();
        for (Map.Entry<String, Sort.Direction> curSort : sorts.entrySet()) {
            sortValues.add(new Sort.Order(curSort.getValue(), curSort.getKey()));
        }
        return new Sort(sortValues);
    }
}

