/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.binding.MultiValueBinding;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.querydsl.binding.QuerydslDefaultBinding;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class QuerydslPredicateBuilder {
    private final ConversionService conversionService;
    private final MultiValueBinding<?, ?> defaultBinding;
    private final Map<PropertyPath, Path<?>> paths;
    private final EntityPathResolver resolver;

    public QuerydslPredicateBuilder(ConversionService conversionService, EntityPathResolver resolver) {
        Assert.notNull(conversionService, "ConversionService must not be null!");
        this.defaultBinding = new QuerydslDefaultBinding();
        this.conversionService = conversionService;
        this.paths = new HashMap();
        this.resolver = resolver;
    }

    public Predicate getPredicate(TypeInformation<?> type, MultiValueMap<String, String> values2, QuerydslBindings bindings) {
        Assert.notNull(bindings, "Context must not be null!");
        BooleanBuilder builder = new BooleanBuilder();
        if (values2.isEmpty()) {
            return builder.getValue();
        }
        for (Map.Entry entry : values2.entrySet()) {
            Collection<Object> value;
            Predicate predicate;
            PropertyPath propertyPath;
            String path;
            if (QuerydslPredicateBuilder.isSingleElementCollectionWithoutText((List)entry.getValue()) || !bindings.isPathVisible(path = (String)entry.getKey(), type.getType()) || (propertyPath = bindings.getPropertyPath(path, type)) == null || (predicate = this.invokeBinding(propertyPath, bindings, value = this.convertToPropertyPathSpecificType((List)entry.getValue(), propertyPath))) == null) continue;
            builder.and(predicate);
        }
        return builder.getValue();
    }

    private Predicate invokeBinding(PropertyPath dotPath, QuerydslBindings bindings, Collection<Object> values2) {
        Path<?> path = this.getPath(dotPath, bindings);
        MultiValueBinding<Object, Path<?>> binding = bindings.getBindingForPath(dotPath);
        binding = binding == null ? this.defaultBinding : binding;
        return binding.bind(path, values2);
    }

    private Path<?> getPath(PropertyPath path, QuerydslBindings bindings) {
        Path<?> resolvedPath = bindings.getExistingPath(path);
        if (resolvedPath != null) {
            return resolvedPath;
        }
        if ((resolvedPath = this.paths.get(resolvedPath)) != null) {
            return resolvedPath;
        }
        resolvedPath = this.reifyPath(path, null);
        this.paths.put(path, resolvedPath);
        return resolvedPath;
    }

    private Path<?> reifyPath(PropertyPath path, Path<?> base) {
        Path<?> entityPath = base != null ? base : this.resolver.createPath(path.getOwningType().getType());
        Field field = ReflectionUtils.findField(entityPath.getClass(), path.getSegment());
        Object value = ReflectionUtils.getField(field, entityPath);
        if (path.hasNext()) {
            return this.reifyPath(path.next(), (Path)value);
        }
        return (Path)value;
    }

    private Collection<Object> convertToPropertyPathSpecificType(List<String> source, PropertyPath path) {
        PropertyPath leafProperty = path.getLeafProperty();
        Class<?> targetType = leafProperty.getOwningType().getProperty(leafProperty.getSegment()).getType();
        if (source.isEmpty() || QuerydslPredicateBuilder.isSingleElementCollectionWithoutText(source)) {
            return Collections.emptyList();
        }
        ArrayList<Object> target = new ArrayList<Object>(source.size());
        for (String value : source) {
            target.add(this.conversionService.canConvert(String.class, targetType) ? this.conversionService.convert(value, TypeDescriptor.forObject(value), QuerydslPredicateBuilder.getTargetTypeDescriptor(path)) : value);
        }
        return target;
    }

    private static TypeDescriptor getTargetTypeDescriptor(PropertyPath path) {
        PropertyPath leafProperty = path.getLeafProperty();
        Class<?> owningType = leafProperty.getOwningType().getType();
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(owningType, leafProperty.getSegment());
        if (descriptor == null) {
            return TypeDescriptor.nested(ReflectionUtils.findField(owningType, leafProperty.getSegment()), 0);
        }
        return TypeDescriptor.nested(new Property(owningType, descriptor.getReadMethod(), descriptor.getWriteMethod(), leafProperty.getSegment()), 0);
    }

    private static boolean isSingleElementCollectionWithoutText(List<String> source) {
        return source.size() == 1 && !StringUtils.hasText(source.get(0));
    }
}

