/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

public class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> createStreamFromIterator(Iterator<T> iterator2) {
        Assert.notNull(iterator2, "Iterator must not be null!");
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator2, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return iterator2 instanceof CloseableIterator ? (Stream)stream.onClose(new CloseableIteratorDisposingRunnable((CloseableIterator)iterator2)) : stream;
    }

    private static class CloseableIteratorDisposingRunnable
    implements Runnable {
        private CloseableIterator<?> closeable;

        public CloseableIteratorDisposingRunnable(CloseableIterator<?> closeable) {
            this.closeable = closeable;
        }

        @Override
        public void run() {
            if (this.closeable != null) {
                this.closeable.close();
            }
        }
    }
}

