/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.DeliveryMode;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventFilter;
import com.amazonaws.event.ProgressListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressListenerChain
implements ProgressListener,
DeliveryMode {
    private static final Log log = LogFactory.getLog(ProgressListenerChain.class);
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private final ProgressEventFilter progressEventFilter;
    private volatile boolean syncCallSafe = true;

    public ProgressListenerChain(ProgressListener ... listeners) {
        this((ProgressEventFilter)null, listeners);
    }

    public ProgressListenerChain(ProgressEventFilter progressEventFilter, ProgressListener ... listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException("Progress Listeners cannot be null.");
        }
        for (ProgressListener listener2 : listeners) {
            this.addProgressListener(listener2);
        }
        this.progressEventFilter = progressEventFilter;
    }

    public synchronized void addProgressListener(ProgressListener listener2) {
        if (listener2 == null) {
            return;
        }
        if (this.syncCallSafe) {
            this.syncCallSafe = DeliveryMode.Check.isSyncCallSafe(listener2);
        }
        this.listeners.add(listener2);
    }

    public synchronized void removeProgressListener(ProgressListener listener2) {
        if (listener2 == null) {
            return;
        }
        this.listeners.remove(listener2);
    }

    protected List<ProgressListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void progressChanged(ProgressEvent progressEvent) {
        ProgressEvent filteredEvent = progressEvent;
        if (this.progressEventFilter != null && (filteredEvent = this.progressEventFilter.filter(progressEvent)) == null) {
            return;
        }
        for (ProgressListener listener2 : this.listeners) {
            try {
                listener2.progressChanged(filteredEvent);
            }
            catch (RuntimeException e) {
                log.warn("Couldn't update progress listener", e);
            }
        }
    }

    @Override
    public boolean isSyncCallSafe() {
        return this.syncCallSafe;
    }
}

