/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.DeliveryMode;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.LogFactory;

public class SDKProgressPublisher {
    private static volatile Future<?> latestFutureTask;

    public static Future<?> publishProgress(ProgressListener listener2, ProgressEventType type) {
        if (listener2 == ProgressListener.NOOP || listener2 == null || type == null) {
            return null;
        }
        return SDKProgressPublisher.deliverEvent(listener2, new ProgressEvent(type));
    }

    private static Future<?> deliverEvent(final ProgressListener listener2, final ProgressEvent event) {
        DeliveryMode mode;
        if (listener2 instanceof DeliveryMode && (mode = (DeliveryMode)((Object)listener2)).isSyncCallSafe()) {
            return SDKProgressPublisher.quietlyCallListener(listener2, event);
        }
        latestFutureTask = LazyHolder.executor.submit(new Runnable(){

            @Override
            public void run() {
                listener2.progressChanged(event);
            }
        });
        return latestFutureTask;
    }

    private static Future<?> quietlyCallListener(ProgressListener listener2, ProgressEvent event) {
        try {
            listener2.progressChanged(event);
        }
        catch (Throwable t) {
            LogFactory.getLog(SDKProgressPublisher.class).debug("Failure from the event listener", t);
        }
        return null;
    }

    public static Future<?> publishRequestContentLength(ProgressListener listener2, long bytes) {
        return SDKProgressPublisher.publishByteCountEvent(listener2, ProgressEventType.REQUEST_CONTENT_LENGTH_EVENT, bytes);
    }

    public static Future<?> publishResponseContentLength(ProgressListener listener2, long bytes) {
        return SDKProgressPublisher.publishByteCountEvent(listener2, ProgressEventType.RESPONSE_CONTENT_LENGTH_EVENT, bytes);
    }

    public static Future<?> publishRequestBytesTransferred(ProgressListener listener2, long bytes) {
        return SDKProgressPublisher.publishByteCountEvent(listener2, ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT, bytes);
    }

    public static Future<?> publishResponseBytesTransferred(ProgressListener listener2, long bytes) {
        return SDKProgressPublisher.publishByteCountEvent(listener2, ProgressEventType.RESPONSE_BYTE_TRANSFER_EVENT, bytes);
    }

    private static Future<?> publishByteCountEvent(ProgressListener listener2, ProgressEventType type, long bytes) {
        if (listener2 == ProgressListener.NOOP || listener2 == null || bytes <= 0L) {
            return null;
        }
        return SDKProgressPublisher.deliverEvent(listener2, new ProgressEvent(type, bytes));
    }

    public static Future<?> publishRequestReset(ProgressListener listener2, long bytesReset) {
        return SDKProgressPublisher.publishResetEvent(listener2, ProgressEventType.HTTP_REQUEST_CONTENT_RESET_EVENT, bytesReset);
    }

    public static Future<?> publishResponseReset(ProgressListener listener2, long bytesReset) {
        return SDKProgressPublisher.publishResetEvent(listener2, ProgressEventType.HTTP_RESPONSE_CONTENT_RESET_EVENT, bytesReset);
    }

    public static Future<?> publishResponseBytesDiscarded(ProgressListener listener2, long bytesDiscarded) {
        return SDKProgressPublisher.publishResetEvent(listener2, ProgressEventType.RESPONSE_BYTE_DISCARD_EVENT, bytesDiscarded);
    }

    private static Future<?> publishResetEvent(ProgressListener listener2, ProgressEventType resetEventType, long bytesReset) {
        if (bytesReset <= 0L) {
            return null;
        }
        if (listener2 == ProgressListener.NOOP || listener2 == null) {
            return null;
        }
        return SDKProgressPublisher.deliverEvent(listener2, new ProgressEvent(resetEventType, bytesReset));
    }

    protected static ExecutorService getExecutorService() {
        return LazyHolder.executor;
    }

    protected static Future<?> setLatestFutureTask(Future<?> f) {
        latestFutureTask = f;
        return latestFutureTask;
    }

    @Deprecated
    public static void waitTillCompletion() throws InterruptedException, ExecutionException {
        if (latestFutureTask != null) {
            latestFutureTask.get();
        }
    }

    public static void shutdown(boolean now) {
        if (now) {
            LazyHolder.executor.shutdownNow();
        } else {
            LazyHolder.executor.shutdown();
        }
    }

    private static final class LazyHolder {
        private static final ExecutorService executor = LazyHolder.createNewExecutorService();

        private LazyHolder() {
        }

        private static ExecutorService createNewExecutorService() {
            return Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName("java-sdk-progress-listener-callback-thread");
                    t.setDaemon(true);
                    return t;
                }
            });
        }
    }
}

