/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.db.repo.SnapshotRepo;
import org.duracloud.snapshot.dto.SnapshotStatus;
import org.duracloud.snapshot.service.EventLog;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.ExecutionListenerConfig;
import org.duracloud.snapshot.service.impl.SnapshotJobParameterMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="jobListener")
public class SnapshotJobExecutionListener
implements JobExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(SnapshotJobExecutionListener.class);
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private SnapshotRepo snapshotRepo;
    @Autowired
    private SnapshotManager snapshotManager;
    @Autowired
    private EventLog eventLog;
    private ExecutionListenerConfig config;

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setSnapshotRepo(SnapshotRepo snapshotRepo) {
        this.snapshotRepo = snapshotRepo;
    }

    public void init(ExecutionListenerConfig config) {
        this.config = config;
    }

    @Override
    @Transactional
    public void beforeJob(JobExecution jobExecution) {
        log.debug("entering beforeJob()");
        JobParameters jobParams = jobExecution.getJobParameters();
        String snapshotId = SnapshotJobParameterMarshaller.unmarshal(jobParams);
        String jobName = jobExecution.getJobInstance().getJobName();
        if (jobName.equals("snapshot")) {
            SnapshotStatus status = SnapshotStatus.TRANSFERRING_FROM_DURACLOUD;
            log.debug("updating snapshot status to " + (Object)((Object)status) + " for snapshot.name = " + snapshotId + "; jobParameters = " + jobParams);
            Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
            this.changeSnapshotStatus(snapshot, status, "");
        }
    }

    @Override
    @Transactional
    public void afterJob(JobExecution jobExecution) {
        log.info("entering afterJob()...");
        JobParameters jobParams = jobExecution.getJobParameters();
        BatchStatus status = jobExecution.getStatus();
        String snapshotId = SnapshotJobParameterMarshaller.unmarshal(jobParams);
        Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
        String snapshotPath = ContentDirUtils.getDestinationPath(snapshot.getName(), this.config.getContentRoot());
        log.info("Completed snapshot: {} with status: {}", (Object)snapshotId, (Object)status);
        if (BatchStatus.COMPLETED.equals((Object)status)) {
            File snapshotDir = new File(snapshotPath);
            snapshot.setTotalSizeInBytes(FileUtils.sizeOfDirectory(snapshotDir));
            String subject = "DuraCloud content snapshot ready for preservation";
            String message = "A DuraCloud content snapshot has been transferred from DuraCloud to bridge storage and ready to move into preservation storage.\n\nsnapshot-id=" + snapshotId + "\nsnapshot-path=" + snapshotPath;
            this.sendEmail(subject, message, this.config.getAllEmailAddresses());
            this.changeSnapshotStatus(snapshot, SnapshotStatus.REPLICATING_TO_STORAGE, "");
            String history = "[{'snapshot-action':'SNAPSHOT_STAGED'},{'snapshot-id':'" + snapshotId + "'}]";
            this.snapshotManager.updateHistory(snapshot, history);
        } else {
            String subject = "DuraCloud content snapshot failed to complete";
            String errorDescription = jobExecution.getExitStatus().getExitDescription();
            String message = "A DuraCloud content snapshot has failed to complete.\n\nsnapshot-id=" + snapshot.getName() + "\nsnapshot-path=" + snapshotPath + "\nerror-description=" + errorDescription;
            this.sendEmail(subject, message, this.config.getDuracloudEmailAddresses());
            this.changeSnapshotStatus(snapshot, SnapshotStatus.FAILED_TO_TRANSFER_FROM_DURACLOUD, "batch job did not complete: batch status = " + (Object)((Object)status));
            log.error("transfer from duracloud failed: " + errorDescription);
        }
    }

    private void changeSnapshotStatus(Snapshot snapshot, SnapshotStatus status, String msg) {
        snapshot.setStatus(status);
        snapshot.setStatusText(msg);
        this.snapshotRepo.save(snapshot);
        this.eventLog.logSnapshotUpdate(snapshot);
        log.info("Updated status of " + snapshot + " to " + (Object)((Object)status));
    }

    private void sendEmail(String subject, String msg, String ... destinations) {
        try {
            this.notificationManager.sendNotification(NotificationType.EMAIL, subject, msg.toString(), destinations);
            log.info("sent email with subject=\"" + subject + "\" to " + StringUtils.join((Object[])destinations, ","));
        }
        catch (Exception ex) {
            log.error("failed sent email with subject=\"" + subject + "\"  and body=\"" + msg + "\"to " + StringUtils.join((Object[])destinations, ","));
        }
    }
}

