/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.LongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.SynchronizedLongBag;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableLongBag;
import org.eclipse.collections.impl.block.factory.primitive.IntToIntFunctions;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class LongHashBag
extends AbstractLongIterable
implements MutableLongBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private LongIntHashMap items;
    private int size;

    public LongHashBag() {
        this.items = new LongIntHashMap();
    }

    public LongHashBag(int size2) {
        this.items = new LongIntHashMap(size2);
    }

    public LongHashBag(LongIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public LongHashBag(long ... elements) {
        this();
        this.addAll(elements);
    }

    public LongHashBag(LongHashBag bag) {
        this.items = new LongIntHashMap(bag.sizeDistinct());
        this.addAll(bag);
    }

    public static LongHashBag newBag(int size2) {
        return new LongHashBag(size2);
    }

    public static LongHashBag newBagWith(long ... source) {
        return new LongHashBag(source);
    }

    public static LongHashBag newBag(LongIterable source) {
        if (source instanceof LongHashBag) {
            return new LongHashBag((LongHashBag)source);
        }
        return new LongHashBag(source);
    }

    public static LongHashBag newBag(LongBag source) {
        return new LongHashBag(source);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int sizeDistinct() {
        return this.items.size();
    }

    @Override
    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    @Override
    public LongHashBag with(long element) {
        this.add(element);
        return this;
    }

    public LongHashBag with(long element1, long element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public LongHashBag with(long element1, long element2, long element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    @Override
    public LongHashBag withAll(LongIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    @Override
    public LongHashBag without(long element) {
        this.remove(element);
        return this;
    }

    @Override
    public LongHashBag withoutAll(LongIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    @Override
    public boolean contains(long value) {
        return this.items.containsKey(value);
    }

    @Override
    public int occurrencesOf(long item) {
        return this.items.get(item);
    }

    @Override
    public void forEachWithOccurrences(LongIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    @Override
    public boolean add(long item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(long item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean addAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        for (long each2 : source) {
            this.add(each2);
        }
        return true;
    }

    @Override
    public boolean addAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof LongBag) {
            LongBag otherBag = (LongBag)source;
            otherBag.forEachWithOccurrences(new LongIntProcedure(){

                public void value(long each2, int occurrences) {
                    LongHashBag.this.addOccurrences(each2, occurrences);
                }
            });
        } else {
            LongIterator iterator2 = source.longIterator();
            while (iterator2.hasNext()) {
                long each2 = iterator2.next();
                this.add(each2);
            }
        }
        return true;
    }

    @Override
    public boolean removeAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (long each2 : source) {
            int occurrences = this.items.removeKeyIfAbsent(each2, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongBag) {
            LongBag otherBag = (LongBag)source;
            otherBag.forEachWithOccurrences(new LongIntProcedure(){

                public void value(long each2, int occurrences) {
                    int oldOccurrences = LongHashBag.this.items.removeKeyIfAbsent(each2, 0);
                    LongHashBag longHashBag = LongHashBag.this;
                    longHashBag.size = longHashBag.size - oldOccurrences;
                }
            });
        } else {
            LongIterator iterator2 = source.longIterator();
            while (iterator2.hasNext()) {
                long each2 = iterator2.next();
                int occurrences = this.items.removeKeyIfAbsent(each2, 0);
                this.size -= occurrences;
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(LongIterable source) {
        int oldSize = this.size();
        final LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
        LongHashBag retained = this.select(new LongPredicate(){

            public boolean accept(long key) {
                return sourceSet.contains(key);
            }
        });
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(long ... source) {
        return this.retainAll(LongHashSet.newSetWith(source));
    }

    @Override
    public void addOccurrences(long item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, new IntToIntFunction(){

                public int valueOf(int intParameter) {
                    return intParameter + occurrences;
                }
            });
            this.size += occurrences;
        }
    }

    @Override
    public boolean removeOccurrences(long item, final int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, new IntToIntFunction(){

            public int valueOf(int intParameter) {
                return intParameter - occurrences;
            }
        });
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(final LongProcedure procedure) {
        this.items.forEachKeyValue(new LongIntProcedure(){

            public void value(long key, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    procedure.value(key);
                }
            }
        });
    }

    @Override
    public LongHashBag select(final LongPredicate predicate) {
        final LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each2, int occurrences) {
                if (predicate.accept(each2)) {
                    result.addOccurrences(each2, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public LongHashBag reject(final LongPredicate predicate) {
        final LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each2, int occurrences) {
                if (!predicate.accept(each2)) {
                    result.addOccurrences(each2, occurrences);
                }
            }
        });
        return result;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        MutableLongIterator it = this.longIterator();
        while (it.hasNext()) {
            result = function.valueOf(result, it.next());
        }
        return result;
    }

    @Override
    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof LongBag)) {
            return false;
        }
        final LongBag bag = (LongBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy(new LongPredicate(){

            public boolean accept(long key) {
                return LongHashBag.this.occurrencesOf(key) == bag.occurrencesOf(key);
            }
        });
    }

    @Override
    public int hashCode() {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long eachItem, int occurrences) {
                result.add((int)(eachItem ^ eachItem >>> 32) ^ occurrences);
            }
        });
        return result.getCount();
    }

    @Override
    public void appendString(final Appendable appendable, String start, final String separator, String end) {
        final boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue(new LongIntProcedure(){

                public void value(long each2, int occurrences) {
                    try {
                        for (int i = 0; i < occurrences; ++i) {
                            if (!firstItem[0]) {
                                appendable.append(separator);
                            }
                            appendable.append(String.valueOf(each2));
                            firstItem[0] = false;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int count(final LongPredicate predicate) {
        final Counter result = new Counter();
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each2, int occurrences) {
                if (predicate.accept(each2)) {
                    result.add(occurrences);
                }
            }
        });
        return result.getCount();
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableBag<V> collect(final LongToObjectFunction<? extends V> function) {
        final HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each2, int occurrences) {
                result.addOccurrences(function.valueOf(each2), occurrences);
            }
        });
        return result;
    }

    @Override
    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    @Override
    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    @Override
    public long sum() {
        final long[] result = new long[]{0L};
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each2, int occurrences) {
                result[0] = result[0] + each2 * (long)occurrences;
            }
        });
        return result[0];
    }

    @Override
    public long[] toArray() {
        final long[] array = new long[this.size()];
        final int[] index = new int[]{0};
        this.forEachWithOccurrences(new LongIntProcedure(){

            public void value(long each2, int occurrences) {
                for (int i = 0; i < occurrences; ++i) {
                    array[index[0]] = each2;
                    index[0] = index[0] + 1;
                }
            }
        });
        return array;
    }

    @Override
    public MutableLongBag asUnmodifiable() {
        return new UnmodifiableLongBag(this);
    }

    @Override
    public MutableLongBag asSynchronized() {
        return new SynchronizedLongBag(this);
    }

    @Override
    public ImmutableLongBag toImmutable() {
        return LongBags.immutable.withAll(this);
    }

    @Override
    public MutableLongIterator longIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue(new LongIntProcedure(){

                public void value(long each2, int occurrences) {
                    try {
                        out.writeLong(each2);
                        out.writeInt(occurrences);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        this.items = new LongIntHashMap(size2);
        for (int i = 0; i < size2; ++i) {
            this.addOccurrences(in.readLong(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableLongIterator {
        private final MutableLongIterator longIterator;
        private long currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.longIterator = LongHashBag.this.items.keySet().longIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.longIterator.hasNext();
        }

        public long next() {
            if (this.occurrences == 0) {
                this.currentItem = this.longIterator.next();
                this.occurrences = LongHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.longIterator.remove();
                LongHashBag.this.size--;
            } else {
                LongHashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

