/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable;

import java.util.Iterator;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.map.AbstractMapIterable;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.tuple.AbstractImmutableEntry;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.MapIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableMapIterable<K, V>
extends AbstractMapIterable<K, V>
implements MutableMapIterable<K, V> {
    @Override
    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    @Override
    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.value();
            this.put(key, result);
        }
        return result;
    }

    @Override
    public V getIfAbsentPut(K key, V value) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = value;
            this.put(key, result);
        }
        return result;
    }

    @Override
    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        return this.getIfAbsentPutWith(key, function, key);
    }

    @Override
    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        Object result = this.get(key);
        if (this.isAbsent(result, key)) {
            result = function.valueOf(parameter);
            this.put(key, result);
        }
        return result;
    }

    @Override
    public V add(Pair<K, V> keyValuePair) {
        return this.put(keyValuePair.getOne(), keyValuePair.getTwo());
    }

    @Override
    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        V oldValue = this.getIfAbsent(key, factory);
        V newValue = function.valueOf(oldValue);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        V oldValue = this.getIfAbsent(key, factory);
        V newValue = function.value(oldValue, parameter);
        this.put(key, newValue);
        return newValue;
    }

    @Override
    public <V1> MutableMap<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap());
    }

    @Override
    public <K2, V2> MutableMap<K2, V2> aggregateInPlaceBy(Function<? super V, ? extends K2> groupBy, Function0<? extends V2> zeroValueFactory, Procedure2<? super V2, ? super V> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K2, V2>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public <K2, V2> MutableMap<K2, V2> aggregateBy(Function<? super V, ? extends K2> groupBy, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V, ? extends V2> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K2, V2>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }

    @Override
    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    @Override
    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    @Override
    public RichIterable<Pair<K, V>> keyValuesView() {
        return LazyIterate.adapt(this.entrySet()).collect(AbstractImmutableEntry.getPairFunction());
    }

    @Override
    public <K2, V2> MutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return MapIterate.collect(this, function, UnifiedMap.newMap(this.size()));
    }

    @Override
    public MutableMap<V, K> flipUniqueValues() {
        return MapIterate.flipUniqueValues(this);
    }

    @Override
    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.detect(this, predicate);
    }
}

