/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleKeysMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableDoubleKeySet
implements MutableDoubleSet {
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !AbstractMutableDoubleKeySet.isEmptyKey(key) && !AbstractMutableDoubleKeySet.isRemovedKey(key);
    }

    protected abstract double getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableDoubleKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    @Override
    public int count(DoublePredicate predicate) {
        int count2 = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                ++count2;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                ++count2;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0.0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1.0)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(double element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(double ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(DoubleIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableDoubleSet select(DoublePredicate predicate) {
        DoubleHashSet result = new DoubleHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                result.add(0.0);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                result.add(1.0);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableDoubleSet reject(DoublePredicate predicate) {
        DoubleHashSet result = new DoubleHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0.0)) {
                result.add(0.0);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1.0)) {
                result.add(1.0);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public MutableDoubleSet with(double element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableDoubleSet without(double element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableDoubleSet withAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableDoubleSet withoutAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf(0.0));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf(1.0));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    @Override
    public boolean remove(double key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(DoubleIterable source) {
        int oldSize = this.getOuter().size();
        DoubleIterator iterator2 = source.doubleIterator();
        while (iterator2.hasNext()) {
            this.getOuter().removeKey(iterator2.next());
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public boolean removeAll(double ... source) {
        int oldSize = this.getOuter().size();
        for (double item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    @Override
    public void clear() {
        this.getOuter().clear();
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                return 0.0;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                return 1.0;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    @Override
    public MutableDoubleSet asUnmodifiable() {
        return UnmodifiableDoubleSet.of(this);
    }

    @Override
    public MutableDoubleSet asSynchronized() {
        return SynchronizedDoubleSet.of(this);
    }

    @Override
    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        if (this.getSentinelValues() != null) {
            double nextSum;
            double adjustedValue;
            if (this.getSentinelValues().containsZeroKey) {
                adjustedValue = 0.0 - compensation;
                nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            if (this.getSentinelValues().containsOneKey) {
                adjustedValue = 1.0 - compensation;
                nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            double adjustedValue = this.getKeyAtIndex(i) - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    @Override
    public double max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        double max2 = 0.0;
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max2 = 0.0;
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max2 = 1.0;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && Double.compare(max2, this.getKeyAtIndex(i)) >= 0) continue;
            max2 = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        double min2 = 0.0;
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min2 = 0.0;
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min2 = 1.0;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && Double.compare(this.getKeyAtIndex(i), min2) >= 0) continue;
            min2 = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList(this).sortThis();
    }

    @Override
    public double[] toArray() {
        int size2 = this.getOuter().size();
        final double[] result = new double[size2];
        this.getOuter().forEachKey(new DoubleProcedure(){
            private int index;

            public void value(double each2) {
                result[this.index] = each2;
                ++this.index;
            }
        });
        return result;
    }

    @Override
    public boolean contains(double value) {
        return this.getOuter().containsKey(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        for (double item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator2 = source.doubleIterator();
        while (iterator2.hasNext()) {
            if (this.getOuter().containsKey(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, 0.0);
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, 1.0);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    @Override
    public ImmutableDoubleSet toImmutable() {
        return DoubleSets.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.getOuter().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleSet)) {
            return false;
        }
        DoubleSet other = (DoubleSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
            }
            if (this.getSentinelValues().containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += (int)(Double.doubleToLongBits(this.getKeyAtIndex(i)) ^ Double.doubleToLongBits(this.getKeyAtIndex(i)) >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(0.0));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

