/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.LongStack;
import org.eclipse.collections.api.stack.primitive.MutableLongStack;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedLongStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableLongStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class LongArrayStack
implements MutableLongStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient LongArrayList delegate;

    public LongArrayStack() {
        this.delegate = new LongArrayList();
    }

    private LongArrayStack(int size2) {
        this.delegate = new LongArrayList(size2);
    }

    private LongArrayStack(long ... items) {
        this.delegate = new LongArrayList(items);
    }

    public static LongArrayStack newStackFromTopToBottom(long ... items) {
        LongArrayStack stack = new LongArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static LongArrayStack newStackWith(long ... items) {
        return new LongArrayStack(items);
    }

    public static LongArrayStack newStack(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items);
        return stack;
    }

    public static LongArrayStack newStackFromTopToBottom(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    public void push(long item) {
        this.delegate.add(item);
    }

    @Override
    public long pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    @Override
    public LongList pop(int count2) {
        this.checkPositiveValueForCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new LongArrayList(0);
        }
        LongArrayList subList = new LongArrayList(count2);
        while (count2 > 0) {
            subList.add(this.pop());
            --count2;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    private void checkSizeLessThanCount(int count2) {
        if (this.delegate.size() < count2) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count2 + " Size = " + this.delegate.size());
        }
    }

    @Override
    public MutableLongStack select(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableLongStack reject(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public long peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    @Override
    public LongList peek(int count2) {
        this.checkPositiveValueForCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new LongArrayList(0);
        }
        LongArrayList subList = new LongArrayList(count2);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count2; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public long peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.asReversed().longIterator());
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.asReversed().injectInto(injectedValue, function);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public long max() {
        return this.delegate.max();
    }

    @Override
    public long min() {
        return this.delegate.min();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public long[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(long value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(long ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        LazyLongIterable iterable = this.delegate.asReversed();
        LongIterator iterator2 = iterable.longIterator();
        while (iterator2.hasNext()) {
            long item = iterator2.next();
            hashCode2 = 31 * hashCode2 + (int)(item ^ item >>> 32);
        }
        return hashCode2;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newList(this).sortThis();
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public MutableLongStack asUnmodifiable() {
        return new UnmodifiableLongStack(this);
    }

    @Override
    public MutableLongStack asSynchronized() {
        return new SynchronizedLongStack(this);
    }

    @Override
    public ImmutableLongStack toImmutable() {
        return LongStacks.immutable.withAll(this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        LongIterator iterator2 = this.delegate.asReversed().longIterator();
        while (iterator2.hasNext()) {
            long each2 = iterator2.next();
            out.writeLong(each2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        long[] array = new long[size2];
        for (int i = size2 - 1; i >= 0; --i) {
            array[i] = in.readLong();
        }
        this.delegate = LongArrayList.newListWith(array);
    }
}

