/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.SortedSet;
import org.eclipse.collections.api.InternalIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.BagMultimap;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.api.multimap.set.SetMultimap;
import org.eclipse.collections.api.partition.PartitionIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MaxComparatorProcedure;
import org.eclipse.collections.impl.block.procedure.MinComparatorProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapKeyValuePutAllProcedure;
import org.eclipse.collections.impl.block.procedure.MultimapKeyValuePutProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.utility.ArrayListIterate;
import org.eclipse.collections.impl.utility.ListIterate;
import org.eclipse.collections.impl.utility.internal.DefaultSpeciesNewStrategy;
import org.eclipse.collections.impl.utility.internal.IterableIterate;
import org.eclipse.collections.impl.utility.internal.RandomAccessListIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterate {
    private Iterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure) {
        if (iterable instanceof InternalIterable) {
            ((InternalIterable)iterable).forEach(procedure);
        } else if (iterable instanceof ArrayList) {
            ArrayListIterate.forEach((ArrayList)iterable, procedure);
        } else if (iterable instanceof List) {
            ListIterate.forEach((List)iterable, procedure);
        } else if (iterable != null) {
            IterableIterate.forEach(iterable, procedure);
        } else {
            throw new IllegalArgumentException("Cannot perform a forEach on null");
        }
    }

    public static <T, P> void forEachWith(Iterable<T> iterable, Procedure2<? super T, ? super P> procedure, P parameter) {
        if (iterable instanceof InternalIterable) {
            ((InternalIterable)iterable).forEachWith(procedure, parameter);
        } else if (iterable instanceof ArrayList) {
            ArrayListIterate.forEachWith((ArrayList)iterable, procedure, parameter);
        } else if (iterable instanceof List) {
            ListIterate.forEachWith((List)iterable, procedure, parameter);
        } else if (iterable != null) {
            IterableIterate.forEachWith(iterable, procedure, parameter);
        } else {
            throw new IllegalArgumentException("Cannot perform a forEachWith on null");
        }
    }

    public static <T> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (iterable instanceof InternalIterable) {
            ((InternalIterable)iterable).forEachWithIndex(objectIntProcedure);
        } else if (iterable instanceof ArrayList) {
            ArrayListIterate.forEachWithIndex((ArrayList)iterable, objectIntProcedure);
        } else if (iterable instanceof List) {
            ListIterate.forEachWithIndex((List)iterable, objectIntProcedure);
        } else if (iterable != null) {
            IterableIterate.forEachWithIndex(iterable, objectIntProcedure);
        } else {
            throw new IllegalArgumentException("Cannot perform a forEachWithIndex on null");
        }
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).select(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.select((ArrayList)iterable, predicate);
        }
        if (iterable instanceof List) {
            return ListIterate.select((List)iterable, predicate);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.select(iterable, predicate, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable));
        }
        if (iterable != null) {
            return IterableIterate.select(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform a select on null");
    }

    public static <T, IV> Collection<T> selectWith(Iterable<T> iterable, Predicate2<? super T, ? super IV> predicate, IV parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).selectWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.selectWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof List) {
            return ListIterate.selectWith((List)iterable, predicate, parameter);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.selectWith(iterable, predicate, parameter, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable));
        }
        if (iterable != null) {
            return IterableIterate.selectWith(iterable, predicate, parameter, FastList.newList());
        }
        throw new IllegalArgumentException("Cannot perform a selectWith on null");
    }

    public static <T, IV> Twin<MutableList<T>> selectAndRejectWith(Iterable<T> iterable, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).selectAndRejectWith(predicate, injectedValue);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.selectAndRejectWith((ArrayList)iterable, predicate, injectedValue);
        }
        if (iterable instanceof List) {
            return ListIterate.selectAndRejectWith((List)iterable, predicate, injectedValue);
        }
        if (iterable != null) {
            return IterableIterate.selectAndRejectWith(iterable, predicate, injectedValue);
        }
        throw new IllegalArgumentException("Cannot perform a selectAndRejectWith on null");
    }

    public static <T> PartitionIterable<T> partition(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).partition(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.partition((ArrayList)iterable, predicate);
        }
        if (iterable instanceof List) {
            return ListIterate.partition((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.partition(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform a partition on null");
    }

    public static <T, P> PartitionIterable<T> partitionWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).partitionWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.partitionWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof List) {
            return ListIterate.partitionWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.partitionWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform a partition on null");
    }

    public static <T> Collection<T> selectInstancesOf(Iterable<?> iterable, Class<T> clazz) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).selectInstancesOf(clazz);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.selectInstancesOf((ArrayList)iterable, clazz);
        }
        if (iterable instanceof List) {
            return ListIterate.selectInstancesOf((List)iterable, clazz);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.selectInstancesOf(iterable, clazz, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable));
        }
        if (iterable != null) {
            return IterableIterate.selectInstancesOf(iterable, clazz);
        }
        throw new IllegalArgumentException("Cannot perform a selectInstancesOf on null");
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).count(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.count((ArrayList)iterable, predicate);
        }
        if (iterable instanceof List) {
            return ListIterate.count((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.count(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot get a count from null");
    }

    public static <T, IV> int countWith(Iterable<T> iterable, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).countWith(predicate, injectedValue);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.countWith((ArrayList)iterable, predicate, injectedValue);
        }
        if (iterable instanceof List) {
            return ListIterate.countWith((List)iterable, predicate, injectedValue);
        }
        if (iterable != null) {
            return IterableIterate.countWith(iterable, predicate, injectedValue);
        }
        throw new IllegalArgumentException("Cannot get a count from null");
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectIf(predicate, function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectIf((ArrayList)iterable, predicate, function);
        }
        if (iterable instanceof List) {
            return ListIterate.collectIf((List)iterable, predicate, function);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.collectIf(iterable, predicate, function, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable));
        }
        if (iterable != null) {
            return IterableIterate.collectIf(iterable, predicate, function);
        }
        throw new IllegalArgumentException("Cannot perform a collectIf on null");
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).collectIf(predicate, function, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectIf((ArrayList)iterable, predicate, function, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectIf((List)iterable, predicate, function, target);
        }
        if (iterable != null) {
            return IterableIterate.collectIf(iterable, predicate, function, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectIf on null");
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).select(predicate, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.select((ArrayList)iterable, predicate, targetCollection);
        }
        if (iterable instanceof List) {
            return ListIterate.select((List)iterable, predicate, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.select(iterable, predicate, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a select on null");
    }

    public static <T, P, R extends Collection<T>> R selectWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).selectWith(predicate, parameter, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.selectWith((ArrayList)iterable, predicate, parameter, targetCollection);
        }
        if (iterable instanceof List) {
            return ListIterate.selectWith((List)iterable, predicate, parameter, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.selectWith(iterable, predicate, parameter, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a selectWith on null");
    }

    public static <T> Collection<T> take(Iterable<T> iterable, int count2) {
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.take((ArrayList)iterable, count2);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.take((List)iterable, count2);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.take(iterable, count2, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable, count2));
        }
        if (iterable != null) {
            return IterableIterate.take(iterable, count2);
        }
        throw new IllegalArgumentException("Cannot perform a take on null");
    }

    public static <T> Collection<T> drop(Iterable<T> iterable, int count2) {
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.drop((ArrayList)iterable, count2);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.drop((List)iterable, count2);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.drop(iterable, count2, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable, count2));
        }
        if (iterable != null) {
            return IterableIterate.drop(iterable, count2);
        }
        throw new IllegalArgumentException("Cannot perform a drop on null");
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).reject(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.reject((ArrayList)iterable, predicate);
        }
        if (iterable instanceof List) {
            return ListIterate.reject((List)iterable, predicate);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.reject(iterable, predicate, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable));
        }
        if (iterable != null) {
            return IterableIterate.reject(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform a reject on null");
    }

    public static <T extends Comparable<? super T>, L extends List<T>> L sortThis(L list) {
        if (list instanceof MutableList) {
            ((MutableList)list).sortThis();
        } else if (list instanceof ArrayList) {
            ArrayListIterate.sortThis((ArrayList)list);
        } else if (list.size() > 1) {
            Collections.sort(list);
        }
        return list;
    }

    public static <T, L extends List<T>> L sortThis(L list, Comparator<? super T> comparator) {
        if (list instanceof MutableList) {
            ((MutableList)list).sortThis(comparator);
        } else if (list instanceof ArrayList) {
            ArrayListIterate.sortThis((ArrayList)list, comparator);
        } else if (list.size() > 1) {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static <T, L extends List<T>> L sortThis(L list, final Predicate2<? super T, ? super T> predicate) {
        return Iterate.sortThis(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (predicate.accept(o1, o2)) {
                    return -1;
                }
                if (predicate.accept(o2, o1)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public static <T, V extends Comparable<? super V>, L extends List<T>> L sortThisBy(L list, Function<? super T, ? extends V> function) {
        return Iterate.sortThis(list, Comparators.byFunction(function));
    }

    public static <T> boolean removeIf(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).removeIf(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.removeIf((ArrayList)iterable, predicate);
        }
        if (iterable instanceof List) {
            return ListIterate.removeIf((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.removeIf(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform a remove on null");
    }

    public static <T, P> boolean removeIfWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).removeIfWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.removeIfWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof List) {
            return ListIterate.removeIfWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.removeIfWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform a remove on null");
    }

    public static <T, P> Collection<T> rejectWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).rejectWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.rejectWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof List) {
            return ListIterate.rejectWith((List)iterable, predicate, parameter);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.rejectWith(iterable, predicate, parameter, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable));
        }
        if (iterable != null) {
            return IterableIterate.rejectWith(iterable, predicate, parameter, FastList.newList());
        }
        throw new IllegalArgumentException("Cannot perform a rejectWith on null");
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).reject(predicate, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.reject((ArrayList)iterable, predicate, targetCollection);
        }
        if (iterable instanceof List) {
            return ListIterate.reject((List)iterable, predicate, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.reject(iterable, predicate, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a reject on null");
    }

    public static <T, P, R extends Collection<T>> R rejectWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).rejectWith(predicate, parameter, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.rejectWith((ArrayList)iterable, predicate, parameter, targetCollection);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.rejectWith((List)iterable, predicate, parameter, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.rejectWith(iterable, predicate, parameter, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a rejectWith on null");
    }

    public static <T, R extends Collection<T>> R addAllTo(Iterable<? extends T> iterable, R targetCollection) {
        Iterate.addAllIterable(iterable, targetCollection);
        return targetCollection;
    }

    public static <T> boolean addAllIterable(Iterable<? extends T> iterable, Collection<T> targetCollection) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        if (iterable instanceof Collection) {
            return targetCollection.addAll((Collection)iterable);
        }
        int oldSize = targetCollection.size();
        Iterate.forEachWith(iterable, Procedures2.addToCollection(), targetCollection);
        return targetCollection.size() != oldSize;
    }

    public static <T, R extends Collection<T>> R removeAllFrom(Iterable<? extends T> iterable, R targetCollection) {
        Iterate.removeAllIterable(iterable, targetCollection);
        return targetCollection;
    }

    public static <T> boolean removeAllIterable(Iterable<? extends T> iterable, Collection<T> targetCollection) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        if (iterable instanceof Collection) {
            return targetCollection.removeAll((Collection)iterable);
        }
        int oldSize = targetCollection.size();
        Iterate.forEachWith(iterable, Procedures2.removeFromCollection(), targetCollection);
        return targetCollection.size() != oldSize;
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collect(function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collect((ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.collect((List)iterable, function);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.collect(iterable, function, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable, ((Collection)iterable).size()));
        }
        if (iterable != null) {
            return IterableIterate.collect(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a collect on null");
    }

    public static <T, A, R extends Collection<A>> R collect(Iterable<T> iterable, Function<? super T, ? extends A> function, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).collect(function, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collect((ArrayList)iterable, function, targetCollection);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.collect((List)iterable, function, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.collect(iterable, function, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a collect on null");
    }

    public static <T> MutableBooleanCollection collectBoolean(Iterable<T> iterable, BooleanFunction<? super T> booleanFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectBoolean(booleanFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectBoolean((ArrayList)iterable, booleanFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectBoolean((List)iterable, booleanFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectBoolean(iterable, booleanFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectBoolean on null");
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(Iterable<T> iterable, BooleanFunction<? super T> booleanFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectBoolean(booleanFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectBoolean((ArrayList)iterable, booleanFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectBoolean((List)iterable, booleanFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectBoolean(iterable, booleanFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectBoolean on null");
    }

    public static <T> MutableByteCollection collectByte(Iterable<T> iterable, ByteFunction<? super T> byteFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectByte(byteFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectByte((ArrayList)iterable, byteFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectByte((List)iterable, byteFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectByte(iterable, byteFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectByte on null");
    }

    public static <T, R extends MutableByteCollection> R collectByte(Iterable<T> iterable, ByteFunction<? super T> byteFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectByte(byteFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectByte((ArrayList)iterable, byteFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectByte((List)iterable, byteFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectByte(iterable, byteFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectByte on null");
    }

    public static <T> MutableCharCollection collectChar(Iterable<T> iterable, CharFunction<? super T> charFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectChar(charFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectChar((ArrayList)iterable, charFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectChar((List)iterable, charFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectChar(iterable, charFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectChar on null");
    }

    public static <T, R extends MutableCharCollection> R collectChar(Iterable<T> iterable, CharFunction<? super T> charFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectChar(charFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectChar((ArrayList)iterable, charFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectChar((List)iterable, charFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectChar(iterable, charFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectChar on null");
    }

    public static <T> MutableDoubleCollection collectDouble(Iterable<T> iterable, DoubleFunction<? super T> doubleFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectDouble(doubleFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectDouble((ArrayList)iterable, doubleFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectDouble((List)iterable, doubleFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectDouble(iterable, doubleFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectDouble on null");
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(Iterable<T> iterable, DoubleFunction<? super T> doubleFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectDouble(doubleFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectDouble((ArrayList)iterable, doubleFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectDouble((List)iterable, doubleFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectDouble(iterable, doubleFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectDouble on null");
    }

    public static <T> MutableFloatCollection collectFloat(Iterable<T> iterable, FloatFunction<? super T> floatFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectFloat(floatFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectFloat((ArrayList)iterable, floatFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectFloat((List)iterable, floatFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectFloat(iterable, floatFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectFloat on null");
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(Iterable<T> iterable, FloatFunction<? super T> floatFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectFloat(floatFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectFloat((ArrayList)iterable, floatFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectFloat((List)iterable, floatFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectFloat(iterable, floatFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectFloat on null");
    }

    public static <T> MutableIntCollection collectInt(Iterable<T> iterable, IntFunction<? super T> intFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectInt(intFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectInt((ArrayList)iterable, intFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectInt((List)iterable, intFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectInt(iterable, intFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectInt on null");
    }

    public static <T, R extends MutableIntCollection> R collectInt(Iterable<T> iterable, IntFunction<? super T> intFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectInt(intFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectInt((ArrayList)iterable, intFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectInt((List)iterable, intFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectInt(iterable, intFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectInt on null");
    }

    public static <T> MutableLongCollection collectLong(Iterable<T> iterable, LongFunction<? super T> longFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectLong(longFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectLong((ArrayList)iterable, longFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectLong((List)iterable, longFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectLong(iterable, longFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectLong on null");
    }

    public static <T, R extends MutableLongCollection> R collectLong(Iterable<T> iterable, LongFunction<? super T> longFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectLong(longFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectLong((ArrayList)iterable, longFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectLong((List)iterable, longFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectLong(iterable, longFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectLong on null");
    }

    public static <T> MutableShortCollection collectShort(Iterable<T> iterable, ShortFunction<? super T> shortFunction) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectShort(shortFunction);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectShort((ArrayList)iterable, shortFunction);
        }
        if (iterable instanceof List) {
            return ListIterate.collectShort((List)iterable, shortFunction);
        }
        if (iterable != null) {
            return IterableIterate.collectShort(iterable, shortFunction);
        }
        throw new IllegalArgumentException("Cannot perform a collectShort on null");
    }

    public static <T, R extends MutableShortCollection> R collectShort(Iterable<T> iterable, ShortFunction<? super T> shortFunction, R target) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectShort(shortFunction, target);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectShort((ArrayList)iterable, shortFunction, target);
        }
        if (iterable instanceof List) {
            return ListIterate.collectShort((List)iterable, shortFunction, target);
        }
        if (iterable != null) {
            return IterableIterate.collectShort(iterable, shortFunction, target);
        }
        throw new IllegalArgumentException("Cannot perform a collectShort on null");
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).flatCollect(function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.flatCollect((ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.flatCollect((List)iterable, function);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.flatCollect(iterable, function, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable, ((Collection)iterable).size()));
        }
        if (iterable != null) {
            return IterableIterate.flatCollect(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a flatCollect on null");
    }

    public static <T, A, R extends Collection<A>> R flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<A>> function, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).flatCollect(function, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.flatCollect((ArrayList)iterable, function, targetCollection);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.flatCollect((List)iterable, function, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.flatCollect(iterable, function, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a flatCollect on null");
    }

    public static <T, P, A> Collection<A> collectWith(Iterable<T> iterable, Function2<? super T, ? super P, ? extends A> function, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).collectWith(function, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectWith((ArrayList)iterable, function, parameter);
        }
        if (iterable instanceof List) {
            return ListIterate.collectWith((List)iterable, function, parameter);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.collectWith(iterable, function, parameter, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable, ((Collection)iterable).size()));
        }
        if (iterable != null) {
            return IterableIterate.collectWith(iterable, function, parameter);
        }
        throw new IllegalArgumentException("Cannot perform a collectWith on null");
    }

    public static <T, P, A, R extends Collection<A>> R collectWith(Iterable<T> iterable, Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).collectWith(function, parameter, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.collectWith((ArrayList)iterable, function, parameter, targetCollection);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.collectWith((List)iterable, function, parameter, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.collectWith(iterable, function, parameter, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a collectWith on null");
    }

    public static <T> Collection<T> flatten(Iterable<? extends Iterable<T>> iterable) {
        return Iterate.flatCollect(iterable, Functions.identity());
    }

    public static <T, R extends Collection<T>> R flatten(Iterable<? extends Iterable<T>> iterable, R targetCollection) {
        return Iterate.flatCollect(iterable, Functions.identity(), targetCollection);
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).getFirst();
        }
        if (iterable instanceof List) {
            return ListIterate.getFirst((List)iterable);
        }
        if (iterable instanceof SortedSet && !((SortedSet)iterable).isEmpty()) {
            return (T)((SortedSet)iterable).first();
        }
        if (iterable instanceof Collection) {
            return Iterate.isEmpty(iterable) ? null : (T)iterable.iterator().next();
        }
        if (iterable != null) {
            return IterableIterate.getFirst(iterable);
        }
        throw new IllegalArgumentException("Cannot get first from null");
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).isEmpty();
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return IterableIterate.isEmpty(iterable);
    }

    public static boolean notEmpty(Iterable<?> iterable) {
        return !Iterate.isEmpty(iterable);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).getLast();
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.getLast((List)iterable);
        }
        if (iterable instanceof SortedSet && !((SortedSet)iterable).isEmpty()) {
            return (T)((SortedSet)iterable).last();
        }
        if (iterable instanceof LinkedList && !((LinkedList)iterable).isEmpty()) {
            return (T)((LinkedList)iterable).getLast();
        }
        if (iterable != null) {
            return IterableIterate.getLast(iterable);
        }
        throw new IllegalArgumentException("Cannot get last from null");
    }

    public static <T> T detect(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).detect(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.detect((ArrayList)iterable, predicate);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.detect((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.detect(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform detect on null");
    }

    public static <T, P> T detectWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).detectWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.detectWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.detectWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.detectWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform detectWith on null");
    }

    public static <T> T detectIfNone(Iterable<T> iterable, Predicate<? super T> predicate, T ifNone) {
        T result = Iterate.detect(iterable, predicate);
        return result == null ? ifNone : result;
    }

    public static <T, P> T detectWithIfNone(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter, T ifNone) {
        T result = Iterate.detectWith(iterable, predicate, parameter);
        return result == null ? ifNone : result;
    }

    public static <T> int detectIndex(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.detectIndex((ArrayList)iterable, predicate);
        }
        if (iterable instanceof List) {
            return ListIterate.detectIndex((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.detectIndex(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform detectIndex on null");
    }

    public static <T, P> int detectIndexWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.detectIndexWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof List) {
            return ListIterate.detectIndexWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.detectIndexWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform detectIndexWith on null");
    }

    public static <T, IV> IV injectInto(IV injectValue, Iterable<T> iterable, Function2<? super IV, ? super T, ? extends IV> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).injectInto(injectValue, function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.injectInto(injectValue, (ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.injectInto(injectValue, (List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.injectInto(injectValue, iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T> int injectInto(int injectValue, Iterable<T> iterable, IntObjectToIntFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).injectInto(injectValue, function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.injectInto(injectValue, (ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.injectInto(injectValue, (List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.injectInto(injectValue, iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T> long injectInto(long injectValue, Iterable<T> iterable, LongObjectToLongFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).injectInto(injectValue, function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.injectInto(injectValue, (ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.injectInto(injectValue, (List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.injectInto(injectValue, iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T> double injectInto(double injectValue, Iterable<T> iterable, DoubleObjectToDoubleFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).injectInto(injectValue, function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.injectInto(injectValue, (ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.injectInto(injectValue, (List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.injectInto(injectValue, iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T> float injectInto(float injectValue, Iterable<T> iterable, FloatObjectToFloatFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).injectInto(injectValue, function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.injectInto(injectValue, (ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.injectInto(injectValue, (List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.injectInto(injectValue, iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T> long sumOfInt(Iterable<T> iterable, IntFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumOfInt(function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumOfInt((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.sumOfInt(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumOfInt on null");
    }

    public static <T> long sumOfLong(Iterable<T> iterable, LongFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumOfLong(function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumOfLong((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.sumOfLong(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumOfLong on null");
    }

    public static <T> double sumOfFloat(Iterable<T> iterable, FloatFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumOfFloat(function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumOfFloat((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.sumOfFloat(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumOfFloat on null");
    }

    public static <T> double sumOfDouble(Iterable<T> iterable, DoubleFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumOfDouble(function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumOfDouble((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.sumOfDouble(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumOfDouble on null");
    }

    public static <T> BigDecimal sumOfBigDecimal(Iterable<T> iterable, Function<? super T, BigDecimal> function) {
        if (iterable instanceof List) {
            return ListIterate.sumOfBigDecimal((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.sumOfBigDecimal(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumOfBigDecimal on null");
    }

    public static <T> BigInteger sumOfBigInteger(Iterable<T> iterable, Function<? super T, BigInteger> function) {
        if (iterable instanceof List) {
            return ListIterate.sumOfBigInteger((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.sumOfBigInteger(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumOfBigDecimal on null");
    }

    public static <V, T> MutableMap<V, BigDecimal> sumByBigDecimal(Iterable<T> iterable, Function<T, V> groupBy, Function<? super T, BigDecimal> function) {
        if (iterable instanceof List) {
            return ListIterate.sumByBigDecimal((List)iterable, groupBy, function);
        }
        if (iterable != null) {
            return IterableIterate.sumByBigDecimal(iterable, groupBy, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumByBigDecimal on null");
    }

    public static <V, T> MutableMap<V, BigInteger> sumByBigInteger(Iterable<T> iterable, Function<T, V> groupBy, Function<? super T, BigInteger> function) {
        if (iterable instanceof List) {
            return ListIterate.sumByBigInteger((List)iterable, groupBy, function);
        }
        if (iterable != null) {
            return IterableIterate.sumByBigInteger(iterable, groupBy, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumByBigInteger on null");
    }

    public static <T, V> ObjectLongMap<V> sumByInt(Iterable<T> iterable, Function<T, V> groupBy, IntFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumByInt(groupBy, function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumByInt((List)iterable, groupBy, function);
        }
        if (iterable != null) {
            return IterableIterate.sumByInt(iterable, groupBy, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumByInt on null");
    }

    public static <T, V> ObjectLongMap<V> sumByLong(Iterable<T> iterable, Function<T, V> groupBy, LongFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumByLong(groupBy, function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumByLong((List)iterable, groupBy, function);
        }
        if (iterable != null) {
            return IterableIterate.sumByLong(iterable, groupBy, function);
        }
        throw new IllegalArgumentException("Cannot perform an sumByLong on null");
    }

    public static <T, V> ObjectDoubleMap<V> sumByFloat(Iterable<T> iterable, Function<T, V> groupBy, FloatFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumByFloat(groupBy, function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumByFloat((List)iterable, groupBy, function);
        }
        if (iterable != null) {
            return IterableIterate.sumByFloat(iterable, groupBy, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T, V> ObjectDoubleMap<V> sumByDouble(Iterable<T> iterable, Function<T, V> groupBy, DoubleFunction<? super T> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).sumByDouble(groupBy, function);
        }
        if (iterable instanceof List) {
            return ListIterate.sumByDouble((List)iterable, groupBy, function);
        }
        if (iterable != null) {
            return IterableIterate.sumByDouble(iterable, groupBy, function);
        }
        throw new IllegalArgumentException("Cannot perform an injectInto on null");
    }

    public static <T, IV, P> IV injectIntoWith(IV injectValue, Iterable<T> iterable, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).injectIntoWith(injectValue, function, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.injectIntoWith(injectValue, (ArrayList)iterable, function, parameter);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.injectIntoWith(injectValue, (List)iterable, function, parameter);
        }
        if (iterable != null) {
            return IterableIterate.injectIntoWith(injectValue, iterable, function, parameter);
        }
        throw new IllegalArgumentException("Cannot perform an injectIntoWith on null");
    }

    public static <T> boolean anySatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).anySatisfy(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.anySatisfy((ArrayList)iterable, predicate);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.anySatisfy((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.anySatisfy(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform an anySatisfy on null");
    }

    public static <T, P> boolean anySatisfyWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).anySatisfyWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.anySatisfyWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.anySatisfyWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.anySatisfyWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform an anySatisfyWith on null");
    }

    public static <T> boolean allSatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).allSatisfy(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.allSatisfy((ArrayList)iterable, predicate);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.allSatisfy((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.allSatisfy(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform an allSatisfy on null");
    }

    public static <T, P> boolean allSatisfyWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).allSatisfyWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.allSatisfyWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.allSatisfyWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.allSatisfyWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform an allSatisfyWith on null");
    }

    public static <T> boolean noneSatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).noneSatisfy(predicate);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.noneSatisfy((ArrayList)iterable, predicate);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.noneSatisfy((List)iterable, predicate);
        }
        if (iterable != null) {
            return IterableIterate.noneSatisfy(iterable, predicate);
        }
        throw new IllegalArgumentException("Cannot perform an allSatisfy on null");
    }

    public static <T, P> boolean noneSatisfyWith(Iterable<T> iterable, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).noneSatisfyWith(predicate, parameter);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.noneSatisfyWith((ArrayList)iterable, predicate, parameter);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.noneSatisfyWith((List)iterable, predicate, parameter);
        }
        if (iterable != null) {
            return IterableIterate.noneSatisfyWith(iterable, predicate, parameter);
        }
        throw new IllegalArgumentException("Cannot perform an noneSatisfyWith on null");
    }

    public static <T, K> MutableMap<K, T> toMap(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction) {
        UnifiedMap map2 = UnifiedMap.newMap();
        Iterate.forEach(iterable, new MapCollectProcedure(map2, keyFunction));
        return map2;
    }

    public static <T, K, V> MutableMap<K, V> toMap(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return Iterate.addToMap(iterable, keyFunction, valueFunction, UnifiedMap.newMap());
    }

    public static <T, K, V, M extends Map<K, V>> M addToMap(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, M map2) {
        Iterate.forEach(iterable, new MapCollectProcedure(map2, keyFunction));
        return map2;
    }

    public static <T, K, V, M extends Map<K, V>> M addToMap(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, M map2) {
        Iterate.forEach(iterable, new MapCollectProcedure<T, K, V>(map2, keyFunction, valueFunction));
        return map2;
    }

    public static <T, K, V, R extends MutableMultimap<K, V>> R toMultimap(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Iterable<V>> valuesFunction, R targetMultimap) {
        Iterate.forEach(iterable, new MultimapKeyValuePutAllProcedure(targetMultimap, keyFunction, valuesFunction));
        return targetMultimap;
    }

    public static <T extends Comparable<? super T>> MutableList<T> toSortedList(Iterable<T> iterable) {
        return Iterate.toSortedList(iterable, Comparators.naturalOrder());
    }

    public static <T> MutableList<T> toSortedList(Iterable<T> iterable, Comparator<? super T> comparator) {
        return FastList.newList(iterable).sortThis((Comparator)comparator);
    }

    public static int sizeOf(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).size();
        }
        return Iterate.count(iterable, Predicates.alwaysTrue());
    }

    public static boolean contains(Iterable<?> iterable, Object value) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(value);
        }
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).contains(value);
        }
        return IterableIterate.detectIndex(iterable, Predicates.equal(value)) > -1;
    }

    public static <T> Object[] toArray(Iterable<T> iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray();
        }
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).toArray();
        }
        MutableList result = Lists.mutable.empty();
        Iterate.addAllTo(iterable, result);
        return result.toArray();
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, T[] target) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray(target);
        }
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).toArray(target);
        }
        MutableList<T> result = Lists.mutable.empty();
        Iterate.addAllTo(iterable, result);
        return result.toArray(target);
    }

    public static <T, V> MutableMultimap<V, T> groupBy(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).groupBy(function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.groupBy((ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.groupBy((List)iterable, function);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.groupBy(iterable, function, FastListMultimap.newMultimap());
        }
        if (iterable != null) {
            return IterableIterate.groupBy(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a groupBy on null");
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(Iterable<T> iterable, Function<? super T, ? extends V> function, R targetMultimap) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).groupBy(function, targetMultimap);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.groupBy((ArrayList)iterable, function, targetMultimap);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.groupBy((List)iterable, function, targetMultimap);
        }
        if (iterable != null) {
            return IterableIterate.groupBy(iterable, function, targetMultimap);
        }
        throw new IllegalArgumentException("Cannot perform a groupBy on null");
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.aggregateInPlaceBy((ArrayList)iterable, groupBy, zeroValueFactory, mutatingAggregator);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.aggregateInPlaceBy((List)iterable, groupBy, zeroValueFactory, mutatingAggregator);
        }
        if (iterable != null) {
            return IterableIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator);
        }
        throw new IllegalArgumentException("Cannot perform an aggregateInPlaceBy on null");
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.aggregateBy((ArrayList)iterable, groupBy, zeroValueFactory, nonMutatingAggregator);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.aggregateBy((List)iterable, groupBy, zeroValueFactory, nonMutatingAggregator);
        }
        if (iterable != null) {
            return IterableIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator);
        }
        throw new IllegalArgumentException("Cannot perform an aggregateBy on null");
    }

    public static <T, V> MutableMultimap<V, T> groupByEach(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).groupByEach(function);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.groupByEach((ArrayList)iterable, function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.groupByEach((List)iterable, function);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.groupByEach(iterable, function, FastListMultimap.newMultimap());
        }
        if (iterable != null) {
            return IterableIterate.groupByEach(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a groupByEach on null");
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).groupByEach(function, targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.groupByEach((ArrayList)iterable, function, targetCollection);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.groupByEach((List)iterable, function, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.groupByEach(iterable, function, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a groupByEach on null");
    }

    public static <T, K, V, R extends MutableMultimap<K, V>> R groupByAndCollect(Iterable<T> iterable, Function<? super T, ? extends K> groupByFunction, Function<? super T, ? extends V> valueFunction, R targetMultimap) {
        Iterate.forEach(iterable, new MultimapKeyValuePutProcedure<T, K, V>(targetMultimap, groupByFunction, valueFunction));
        return targetMultimap;
    }

    public static <V, T> MutableMap<V, T> groupByUniqueKey(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        if (iterable instanceof List) {
            return ListIterate.groupByUniqueKey((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.groupByUniqueKey(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a groupByUniqueKey on null");
    }

    public static <V, T, R extends MutableMap<V, T>> R groupByUniqueKey(Iterable<T> iterable, Function<? super T, ? extends V> function, R target) {
        if (iterable instanceof List) {
            return ListIterate.groupByUniqueKey((List)iterable, function, target);
        }
        if (iterable != null) {
            return IterableIterate.groupByUniqueKey(iterable, function, target);
        }
        throw new IllegalArgumentException("Cannot perform a groupByUniqueKey on null");
    }

    public static <T> T min(Iterable<T> iterable, Comparator<? super T> comparator) {
        MinComparatorProcedure<T> procedure = new MinComparatorProcedure<T>(comparator);
        Iterate.forEach(iterable, procedure);
        return procedure.getResult();
    }

    public static <T> T max(Iterable<T> iterable, Comparator<? super T> comparator) {
        MaxComparatorProcedure<T> procedure = new MaxComparatorProcedure<T>(comparator);
        Iterate.forEach(iterable, procedure);
        return procedure.getResult();
    }

    public static <T> T min(Iterable<T> iterable) {
        return Iterate.min(iterable, Comparators.naturalOrder());
    }

    public static <T> T max(Iterable<T> iterable) {
        return Iterate.max(iterable, Comparators.naturalOrder());
    }

    public static <T> T getOnly(Iterable<T> iterable) {
        if (iterable != null) {
            return IterableIterate.getOnly(iterable);
        }
        throw new IllegalArgumentException("Cannot perform getOnly on null");
    }

    public static <X, Y> Collection<Pair<X, Y>> zip(Iterable<X> xs, Iterable<Y> ys) {
        if (xs instanceof MutableCollection) {
            return ((MutableCollection)xs).zip(ys);
        }
        if (xs instanceof ArrayList) {
            return ArrayListIterate.zip((ArrayList)xs, ys);
        }
        if (xs instanceof RandomAccess) {
            return RandomAccessListIterate.zip((List)xs, ys);
        }
        if (xs != null) {
            return IterableIterate.zip(xs, ys);
        }
        throw new IllegalArgumentException("Cannot perform a zip on null");
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(Iterable<X> xs, Iterable<Y> ys, R targetCollection) {
        if (xs instanceof RichIterable) {
            return ((RichIterable)xs).zip(ys, targetCollection);
        }
        if (xs instanceof ArrayList) {
            return ArrayListIterate.zip((ArrayList)xs, ys, targetCollection);
        }
        if (xs instanceof RandomAccess) {
            return RandomAccessListIterate.zip((List)xs, ys, targetCollection);
        }
        if (xs != null) {
            return IterableIterate.zip(xs, ys, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a zip on null");
    }

    public static <T> Collection<Pair<T, Integer>> zipWithIndex(Iterable<T> iterable) {
        if (iterable instanceof MutableCollection) {
            return ((MutableCollection)iterable).zipWithIndex();
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.zipWithIndex((ArrayList)iterable);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.zipWithIndex((List)iterable);
        }
        if (iterable instanceof Collection) {
            return IterableIterate.zipWithIndex(iterable, DefaultSpeciesNewStrategy.INSTANCE.speciesNew((Collection)iterable, ((Collection)iterable).size()));
        }
        if (iterable != null) {
            return IterableIterate.zipWithIndex(iterable);
        }
        throw new IllegalArgumentException("Cannot perform a zipWithIndex on null");
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(Iterable<T> iterable, R targetCollection) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).zipWithIndex(targetCollection);
        }
        if (iterable instanceof ArrayList) {
            return ArrayListIterate.zipWithIndex((ArrayList)iterable, targetCollection);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.zipWithIndex((List)iterable, targetCollection);
        }
        if (iterable != null) {
            return IterableIterate.zipWithIndex(iterable, targetCollection);
        }
        throw new IllegalArgumentException("Cannot perform a zipWithIndex on null");
    }

    public static <T> RichIterable<RichIterable<T>> chunk(Iterable<T> iterable, int size2) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).chunk(size2);
        }
        if (iterable != null) {
            return IterableIterate.chunk(iterable, size2);
        }
        throw new IllegalArgumentException("Cannot perform a chunk on null");
    }

    public static <T> String makeString(Iterable<T> iterable) {
        return Iterate.makeString(iterable, ", ");
    }

    public static <T> String makeString(Iterable<T> iterable, String separator) {
        return Iterate.makeString(iterable, "", separator, "");
    }

    public static <T> String makeString(Iterable<T> iterable, String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterate.appendString(iterable, stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public static <T> void appendString(Iterable<T> iterable, Appendable appendable) {
        Iterate.appendString(iterable, appendable, ", ");
    }

    public static <T> void appendString(Iterable<T> iterable, Appendable appendable, String separator) {
        Iterate.appendString(iterable, appendable, "", separator, "");
    }

    public static <T> void appendString(Iterable<T> iterable, Appendable appendable, String start, String separator, String end) {
        if (iterable instanceof MutableCollection) {
            ((MutableCollection)iterable).appendString(appendable, start, separator, end);
        } else if (iterable instanceof RandomAccess) {
            RandomAccessListIterate.appendString((List)iterable, appendable, start, separator, end);
        } else if (iterable != null) {
            IterableIterate.appendString(iterable, appendable, start, separator, end);
        } else {
            throw new IllegalArgumentException("Cannot perform an appendString on null");
        }
    }

    public static <T, V extends Comparable<? super V>> T maxBy(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).maxBy(function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.maxBy((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.maxBy(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a maxBy on null");
    }

    public static <T, V extends Comparable<? super V>> T minBy(Iterable<T> iterable, Function<? super T, ? extends V> function) {
        if (iterable instanceof RichIterable) {
            return ((RichIterable)iterable).minBy(function);
        }
        if (iterable instanceof RandomAccess) {
            return RandomAccessListIterate.minBy((List)iterable, function);
        }
        if (iterable != null) {
            return IterableIterate.minBy(iterable, function);
        }
        throw new IllegalArgumentException("Cannot perform a minBy on null");
    }

    public static <K, V> HashBagMultimap<V, K> flip(BagMultimap<K, V> bagMultimap) {
        final HashBagMultimap result = new HashBagMultimap();
        bagMultimap.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            @Override
            public void value(final K key, Iterable<V> values2) {
                Iterate.forEach(values2, new Procedure<V>(){

                    @Override
                    public void value(V value) {
                        result.put(value, key);
                    }
                });
            }
        });
        return result;
    }

    public static <K, V> HashBagMultimap<V, K> flip(ListMultimap<K, V> listMultimap) {
        final HashBagMultimap result = new HashBagMultimap();
        listMultimap.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            @Override
            public void value(final K key, Iterable<V> values2) {
                Iterate.forEach(values2, new Procedure<V>(){

                    @Override
                    public void value(V value) {
                        result.put(value, key);
                    }
                });
            }
        });
        return result;
    }

    public static <K, V> UnifiedSetMultimap<V, K> flip(SetMultimap<K, V> setMultimap) {
        final UnifiedSetMultimap result = new UnifiedSetMultimap();
        setMultimap.forEachKeyMultiValues(new Procedure2<K, Iterable<V>>(){

            @Override
            public void value(final K key, Iterable<V> values2) {
                Iterate.forEach(values2, new Procedure<V>(){

                    @Override
                    public void value(V value) {
                        result.put(value, key);
                    }
                });
            }
        });
        return result;
    }
}

